/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessagePublishAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Map;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.trace.MuleSoftTraceStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQPublishParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(AnypointMQPublishParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        return NotificationParserUtils.getComponentId(notification).equalsIgnoreCase("anypoint-mq:publish");
    }

    @Override
    public SpanBuilder startProcessorNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startProcessorNotification(notification, muleConnectorConfigStore, spanBuilder);
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        return this.addMQPublishAttributesToSpan(notification, muleConnectorConfigStore, spanBuilder);
    }

    private SpanBuilder addMQPublishAttributesToSpan(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        Map anypointMQAttributes = (Map)NotificationParserUtils.getComponentAnnotation("{config}componentParameters", notification);
        String configRef = (String)anypointMQAttributes.get("config-ref");
        MuleConnectorConfigStore.AnypointMQConfig anypointMQConfig = (MuleConnectorConfigStore.AnypointMQConfig)muleConnectorConfigStore.getConfig(configRef);
        try {
            spanBuilder.setAttribute("publish.scheme", anypointMQConfig.getProtocol());
            spanBuilder.setAttribute("publish.host", anypointMQConfig.getHost());
            spanBuilder.setAttribute("publish.port", anypointMQConfig.getPort());
            spanBuilder.setAttribute("publish.path", anypointMQConfig.getPath());
            spanBuilder.setAttribute("publish.clientId", anypointMQConfig.getClientId());
            spanBuilder.setAttribute("publish.destination", (String)anypointMQAttributes.get("destination"));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    @Override
    public void endProcessorNotification(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        super.endProcessorNotification(notification, traceStore);
        this.addMQPublishResponseAttributesToSpan(notification, traceStore);
    }

    private void addMQPublishResponseAttributesToSpan(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        AnypointMQMessagePublishAttributes mqPublishAttributes = (AnypointMQMessagePublishAttributes)NotificationParserUtils.getMessageAttributes(notification);
        Span span = traceStore.getMessageProcessorSpan(NotificationParserUtils.getMuleSoftTraceId(notification), NotificationParserUtils.getFlowId(notification), NotificationParserUtils.getSpanId(notification));
        try {
            span.setAttribute("publish.response.messageId", mqPublishAttributes.getMessageId());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }
}

