/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.NotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.trace.MuleSoftTraceStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseNotificationParser
implements NotificationParser {
    private static Logger logger = LoggerFactory.getLogger(BaseNotificationParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        return true;
    }

    @Override
    public SpanBuilder startPipelineNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        try {
            spanBuilder.setAttribute("mule.trace.id", NotificationParserUtils.getMuleSoftTraceId(notification));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    @Override
    public void endPipelineNotification(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
    }

    @Override
    public SpanBuilder startProcessorNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        try {
            spanBuilder.setStartTimestamp(NotificationParserUtils.getInstantFrom(notification));
            spanBuilder.setAttribute("start.datetime", NotificationParserUtils.getInstantFrom(notification).toString());
            spanBuilder.setAttribute("doc.name", NotificationParserUtils.getDocName(notification));
            spanBuilder.setAttribute("mule.trace.id", NotificationParserUtils.getMuleSoftTraceId(notification));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    @Override
    public void endProcessorNotification(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        Span span = traceStore.getMessageProcessorSpan(NotificationParserUtils.getMuleSoftTraceId(notification), NotificationParserUtils.getFlowId(notification), NotificationParserUtils.getSpanId(notification));
        Exception e = notification.getException();
        try {
            span.setAttribute("end.datetime", NotificationParserUtils.getInstantFrom(notification).toString());
            if (e != null) {
                span.setStatus(StatusCode.ERROR, e.getMessage());
                span.recordException((Throwable)e);
            }
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
        }
    }
}

