/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.store.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MuleConnectorConfigStore {
    private static Logger logger = LoggerFactory.getLogger(MuleConnectorConfigStore.class);
    private static MuleConnectorConfigStore muleConnectorConfigStore = null;
    private static ExpressionManager expressionManager = null;
    private Map<String, Object> configurations = new ConcurrentHashMap<String, Object>();

    private MuleConnectorConfigStore(MuleConfiguration muleConfiguration, ExpressionManager em) {
        DefaultMuleConfiguration defaultMuleConfiguration = (DefaultMuleConfiguration)muleConfiguration;
        expressionManager = em;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        String httpNS = "http://www.mulesoft.org/schema/mule/http";
        String dbNS = "http://www.mulesoft.org/schema/mule/db";
        String anypointMQNS = "http://www.mulesoft.org/schema/mule/anypoint-mq";
        if (muleConfiguration != null) {
            String dirPath = defaultMuleConfiguration.getMuleHomeDirectory() + "/apps/" + defaultMuleConfiguration.getDataFolderName();
            Iterator itFiles = FileUtils.iterateFiles((File)new File(dirPath), (IOFileFilter)new SuffixFileFilter(".xml"), null);
            while (itFiles.hasNext()) {
                logger.debug("Application source files folder: " + dirPath);
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse((File)itFiles.next());
                    doc.getDocumentElement().normalize();
                    NodeList httpRequesterConfigNodesList = doc.getElementsByTagNameNS(httpNS, "request-config");
                    int httpRequesterConfigNodes = httpRequesterConfigNodesList.getLength();
                    for (int i = 0; i < httpRequesterConfigNodes; ++i) {
                        Node node = httpRequesterConfigNodesList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element e = (Element)node;
                        String configName = e.getAttribute("name");
                        Element e2 = (Element)e.getElementsByTagNameNS(httpNS, "request-connection").item(0);
                        String host = e2.getAttribute("host");
                        String port = e2.getAttribute("port");
                        String protocol = e2.getAttribute("protocol");
                        this.configurations.put(configName, new HttpRequesterConfig(host, port == "" ? "80" : port, protocol == "" ? "HTTP" : protocol));
                    }
                    NodeList dbConfigNodesList = doc.getElementsByTagNameNS(dbNS, "config");
                    int dbConfigNodes = dbConfigNodesList.getLength();
                    for (int i = 0; i < dbConfigNodes; ++i) {
                        Node node = dbConfigNodesList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element e = (Element)node;
                        String configName = e.getAttribute("name");
                        Element e2 = (Element)e.getElementsByTagNameNS(dbNS, "*").item(0);
                        String type = e2.getLocalName();
                        String host = e2.getAttribute("host");
                        String port = e2.getAttribute("port");
                        String user = e2.getAttribute("user");
                        String database = e2.getAttribute("database");
                        this.configurations.put(configName, new DbConfig(host, port, user, database, type));
                    }
                    NodeList anypointMQConfigNodesList = doc.getElementsByTagNameNS(anypointMQNS, "config");
                    int anyppointMQConfigNodes = anypointMQConfigNodesList.getLength();
                    for (int i = 0; i < anyppointMQConfigNodes; ++i) {
                        Node node = anypointMQConfigNodesList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element e = (Element)node;
                        String configName = e.getAttribute("name");
                        Element e2 = (Element)e.getElementsByTagNameNS(anypointMQNS, "connection").item(0);
                        String url = e2.getAttribute("url");
                        String clientId = e2.getAttribute("clientId");
                        this.configurations.put(configName, new AnypointMQConfig(url, clientId));
                    }
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
            }
        }
    }

    public static synchronized MuleConnectorConfigStore getInstance(MuleConfiguration muleConfiguration, ExpressionManager expressionManager) {
        if (muleConnectorConfigStore == null) {
            muleConnectorConfigStore = new MuleConnectorConfigStore(muleConfiguration, expressionManager);
        }
        return muleConnectorConfigStore;
    }

    public <T> T getConfig(String key) {
        return (T)this.configurations.get(key);
    }

    public static String resolveProperty(String property) {
        String value = property;
        try {
            if (property.startsWith("${") && property.endsWith("}")) {
                property = property.substring(2, property.length() - 1);
                String exp = "#[p(\"" + property + "\")]";
                value = (String)expressionManager.evaluate(exp).getValue();
            } else if (expressionManager.isExpression(property)) {
                value = (String)expressionManager.evaluate(property).getValue();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return value;
    }

    public static class HttpRequesterConfig {
        private String host;
        private String port;
        private String protocol;

        public HttpRequesterConfig(String host, String port, String protocol) {
            this.host = MuleConnectorConfigStore.resolveProperty(host);
            this.port = MuleConnectorConfigStore.resolveProperty(port);
            this.protocol = MuleConnectorConfigStore.resolveProperty(protocol);
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }

    public static class DbConfig {
        private String host;
        private String port;
        private String user;
        private String dbName;
        private String connectionType;

        public DbConfig(String host, String port, String user, String dbName, String connectionType) {
            this.host = MuleConnectorConfigStore.resolveProperty(host);
            this.port = MuleConnectorConfigStore.resolveProperty(port);
            this.user = MuleConnectorConfigStore.resolveProperty(user);
            this.dbName = MuleConnectorConfigStore.resolveProperty(dbName);
            this.connectionType = MuleConnectorConfigStore.resolveProperty(connectionType);
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getConnectionType() {
            return this.connectionType;
        }
    }

    public static class AnypointMQConfig {
        private String clientId;
        private URL url;

        public AnypointMQConfig(String url, String clientId) throws MalformedURLException {
            this.url = new URL(MuleConnectorConfigStore.resolveProperty(url));
            this.clientId = MuleConnectorConfigStore.resolveProperty(clientId);
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getUrl() {
            return this.url.toExternalForm();
        }

        public String getHost() {
            return this.url.getHost();
        }

        public String getPort() {
            int port = this.url.getPort();
            return port == -1 ? Integer.toString(this.url.getDefaultPort()) : Integer.toString(port);
        }

        public String getProtocol() {
            return this.url.getProtocol();
        }

        public String getPath() {
            return this.url.getPath();
        }
    }
}

