/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.util;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyValuePair {
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    private String key;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    private String value;
    private static Logger logger = LoggerFactory.getLogger(KeyValuePair.class);

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey(ExpressionManager em, EnrichedServerNotification n) {
        return this.resolve(this.key, em, n);
    }

    public String getValue(ExpressionManager em, EnrichedServerNotification n) {
        return this.resolve(this.value, em, n);
    }

    public static String commaSeparatedList(List<? extends KeyValuePair> pairs) {
        if (pairs == null) {
            return "";
        }
        return pairs.stream().map(KeyValuePair::toString).collect(Collectors.joining(","));
    }

    private String resolve(String property, ExpressionManager em, EnrichedServerNotification n) {
        String value = property;
        try {
            if (property.startsWith("${") && property.endsWith("}")) {
                property = property.substring(2, property.length() - 1);
                String exp = "#[p(\"" + property + "\")]";
                value = (String)em.evaluate(exp).getValue();
            } else if (property.startsWith("\"#[") && property.endsWith("]\"")) {
                String exp = property.substring(1, property.length() - 1);
                ExpressionManagerSession els = em.openSession(n.getEvent().asBindingContext());
                value = (String)els.evaluate(exp, DataType.STRING).getValue();
            } else if (em.isExpression(property)) {
                value = (String)em.evaluate(property).getValue();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            value = "unable to reslove attribute";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

