/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.util.Map;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.AnypointMQMessageAttributesGetter;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.OTelContextPropagator;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQSubscriberParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(AnypointMQSubscriberParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        ComponentIdentifier sourceIdentifier = NotificationParserUtils.getSourceIdentifier(notification);
        String sourceComponent = sourceIdentifier.getNamespace() + ":" + sourceIdentifier.getName();
        int action = Integer.parseInt(notification.getAction().getIdentifier());
        return sourceComponent.equalsIgnoreCase("anypoint-mq:subscriber") && action == 1801;
    }

    @Override
    public SpanBuilder startPipelineNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startPipelineNotification(notification, muleConnectorConfigStore, spanBuilder);
        try {
            spanBuilder.setSpanKind(SpanKind.SERVER);
            spanBuilder = this.addMQSubscriberAttributesToSpan(notification, muleConnectorConfigStore, spanBuilder);
            AnypointMQMessageAttributes anypointMQMessageAttributes = (AnypointMQMessageAttributes)NotificationParserUtils.getMessageAttributes(notification);
            Context context = OTelContextPropagator.extract(anypointMQMessageAttributes, new AnypointMQMessageAttributesGetter());
            spanBuilder.setParent(context);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    @Override
    public SpanBuilder startProcessorNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startProcessorNotification(notification, muleConnectorConfigStore, spanBuilder);
        return this.addMQSubscriberConfigAttributesToSpan(notification, muleConnectorConfigStore, spanBuilder);
    }

    private SpanBuilder addMQSubscriberAttributesToSpan(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        AnypointMQMessageAttributes anypointMQMessageAttributes = (AnypointMQMessageAttributes)NotificationParserUtils.getMessageAttributes(notification);
        try {
            spanBuilder.setAttribute("subscriber.message.contentType", anypointMQMessageAttributes.getContentType());
            spanBuilder.setAttribute("subscriber.destination", anypointMQMessageAttributes.getDestination());
            spanBuilder.setAttribute("subscriber.messageId", anypointMQMessageAttributes.getMessageId());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    private SpanBuilder addMQSubscriberConfigAttributesToSpan(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        Map anypointMQAttributes = (Map)NotificationParserUtils.getComponentAnnotation("{config}componentParameters", notification);
        String configRef = (String)anypointMQAttributes.get("config-ref");
        MuleConnectorConfigStore.AnypointMQConfig anypointMQConfig = (MuleConnectorConfigStore.AnypointMQConfig)muleConnectorConfigStore.getConfig(configRef);
        try {
            spanBuilder.setAttribute("subscriber.scheme", anypointMQConfig.getProtocol());
            spanBuilder.setAttribute("subscriber.host", anypointMQConfig.getHost());
            spanBuilder.setAttribute("subscriber.port", anypointMQConfig.getPort());
            spanBuilder.setAttribute("subscriber.path", anypointMQConfig.getPath());
            spanBuilder.setAttribute("subscriber.clientId", anypointMQConfig.getClientId());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }
}

