/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.trace.MuleSoftTraceStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(LoggerParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        return NotificationParserUtils.getComponentId(notification).equalsIgnoreCase("mule:logger");
    }

    @Override
    public void endProcessorNotification(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        super.endProcessorNotification(notification, traceStore);
        this.addLoggerEventsToSpan(notification, traceStore);
    }

    private void addLoggerEventsToSpan(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        String loggerOutput = (String)TypedValue.unwrap(notification.getEvent().getVariables().get("__LOGGER_OUTPUT_KEY__"));
        Span span = traceStore.getMessageProcessorSpan(NotificationParserUtils.getMuleSoftTraceId(notification), NotificationParserUtils.getFlowId(notification), NotificationParserUtils.getSpanId(notification));
        if (loggerOutput != null && notification.getException() == null) {
            Attributes eventAttributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"logger.output"), (Object)loggerOutput);
            span.addEvent("logger.output.event", eventAttributes);
        }
    }
}

