/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.trace;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.Header;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.OtlpExporterCompressionType;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.OtlpExporterConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.OtlpExporterTransportProtocolType;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.KeyValuePair;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtlpTraceExporterConfig
implements OtlpExporterConfig {
    private Logger logger = LoggerFactory.getLogger(OtlpTraceExporterConfig.class);
    @Parameter
    @DisplayName(value="DISABLE Trace Signals")
    @Placement(order=1, tab="OTLP Trace Exporter")
    @Summary(value="Enable/Disable tracing signal gathering in this application.  If disabled, all other configuration details will be ignored.")
    @Optional(defaultValue="false")
    private boolean disableTraces;
    @Parameter
    @DisplayName(value="Trace Collector Endpoint")
    @Placement(order=10, tab="OTLP Trace Exporter")
    @Summary(value="Target URL to which the OTLP Exporter sends traces. Must be a URL with a scheme of either http or https based on the use of TLS.")
    @Optional(defaultValue="")
    @Example(value="https://otlp.nr-data.net:4318/v1/traces")
    private String traceCollectorEndpoint;
    @Parameter
    @DisplayName(value="Endpoint Certificate Path")
    @Placement(order=20, tab="OTLP Trace Exporter")
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"txt"}, acceptsUrls=true)
    @Optional(defaultValue="")
    @Example(value="mycert.pem")
    @Summary(value="The path to the file containing trusted certificates to use when verifying an OTLP trace server's TLS credentials. The file should contain one or more X.509 certificates in PEM format. By default the host platform's trusted root certificates are used.")
    private String traceCertificatePath;
    @Parameter
    @DisplayName(value="OTLP Transport Protocol")
    @Placement(order=30, tab="OTLP Trace Exporter")
    @Optional(defaultValue="HTTP_PROTOBUF")
    private OtlpExporterTransportProtocolType traceTransportProtocol;
    @Parameter
    @DisplayName(value="Compression Type")
    @Placement(order=40, tab="OTLP Trace Exporter")
    @Optional(defaultValue="NONE")
    private OtlpExporterCompressionType traceCompression;
    @Parameter
    @DisplayName(value="Trace Headers")
    @Placement(order=45, tab="OTLP Trace Exporter")
    @Optional
    @NullSafe
    @Summary(value="Key-value pairs separated by commas to pass as request headers on an OTLP trace export.")
    private List<Header> traceHeaders;
    @Parameter
    @DisplayName(value="Max Queue Size")
    @Placement(order=50, tab="OTLP Trace Exporter")
    @Optional(defaultValue="2048")
    @Summary(value="The maximum number of spans in the waiting queue. Any new spans are dropped once the queue is full.")
    private String maxQueueSize;
    @Parameter
    @DisplayName(value="Max Batch Export Size")
    @Placement(order=60, tab="OTLP Trace Exporter")
    @Optional(defaultValue="512")
    @Summary(value="The maximum number of spans to export in a single batch.")
    private String maxBatchExportSize;
    @Parameter
    @DisplayName(value="Batch Export Delay Interval (millisec)")
    @Placement(order=70, tab="OTLP Trace Exporter")
    @Optional(defaultValue="5000")
    @Summary(value="The delay interval in milliseconds between two consecutive batch exports.")
    private String batchExportDelayInterval;
    @Parameter
    @DisplayName(value="Batch Export Timeout (millsec)")
    @Placement(order=80, tab="OTLP Trace Exporter")
    @Optional(defaultValue="30000")
    @Summary(value="Maximum time (milliseconds) the OTLP exporter will wait for a batch to export before cancelling the export.")
    private String exportTimeout;

    public boolean getDisableTraces() {
        return this.disableTraces;
    }

    public List<Header> getHeaders() {
        return this.traceHeaders;
    }

    public OtlpExporterTransportProtocolType getTransportProtocol() {
        return this.traceTransportProtocol;
    }

    public OtlpExporterCompressionType getCompression() {
        return this.traceCompression;
    }

    public String getCollectorEndpoint() {
        return this.traceCollectorEndpoint;
    }

    public String getCertificatePath() {
        return this.traceCertificatePath;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public String getMaxBatchExportSize() {
        return this.maxBatchExportSize;
    }

    public String getBatchExportDelayInterval() {
        return this.batchExportDelayInterval;
    }

    public String getExportTimeout() {
        return this.exportTimeout;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (!this.getDisableTraces()) {
            config.put("otel.traces.exporter", "otlp");
            config.put("otel.exporter.otlp.traces.protocol", this.getTransportProtocol().getProtocolType());
            config.put("otel.exporter.otlp.traces.endpoint", this.getCollectorEndpoint());
            config.put("otel.exporter.otlp.traces.compression", this.getCompression().getCompressionType());
            config.put("otel.bsp.schedule.delay", this.getBatchExportDelayInterval());
            config.put("otel.bsp.max.queue.size", this.getMaxQueueSize());
            config.put("otel.bsp.max.export.batch.size", this.getMaxBatchExportSize());
            config.put("otel.bsp.export.timeout", this.getExportTimeout());
            config.put("otel.exporter.otlp.traces.headers", KeyValuePair.commaSeparatedList(this.getHeaders()));
            this.logger.debug("get certificate :" + this.getCertificatePath() + " is empty:" + this.getCertificatePath().isEmpty());
            if (!this.getCertificatePath().isEmpty()) {
                config.put("otel.exporter.otlp.traces.certificate", this.getCertificatePath());
            }
            this.logger.info("Trace processing is ENABLED");
        } else {
            config.put("otel.traces.exporter", "none");
            this.logger.info("Trace processing is DISABLED");
        }
        return Collections.unmodifiableMap(config);
    }

    public String toString() {
        return StringUtils.join((Object[])new Map[]{this.getProperties()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtlpTraceExporterConfig that = (OtlpTraceExporterConfig)o;
        return Objects.equals(this.getCollectorEndpoint(), that.getCollectorEndpoint()) && this.getTransportProtocol() == that.getTransportProtocol() && Objects.equals(this.getHeaders(), that.getHeaders());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getCollectorEndpoint(), this.getTransportProtocol(), this.getHeaders()});
    }
}

