/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.metric;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMetricErrors {
    private static final Logger logger = LoggerFactory.getLogger(MuleMetricErrors.class);
    private static MuleMetricErrors muleMetricErrors;
    private LongCounter flowErrorCounter;
    private LongCounter processorErrorCounter;

    private MuleMetricErrors(OpenTelemetry openTelemetry) {
        logger.info("Initializing the Error Metrics");
        Meter meter = openTelemetry.getMeter("org.mulesoft.extension.otel.mule4.observability.agent.metrics");
        this.flowErrorCounter = meter.counterBuilder("mule.flow.errors.total").setDescription("Total number of errors in Mule flow executions.").setUnit("1").build();
        this.processorErrorCounter = meter.counterBuilder("mule.processor.errors.total").setDescription("Total number of errors in Mule message processor invocations.").setUnit("1").build();
    }

    public static void setInstance(OpenTelemetry ot) {
        if (muleMetricErrors == null) {
            muleMetricErrors = new MuleMetricErrors(ot);
        }
    }

    public static MuleMetricErrors getInstance() {
        if (muleMetricErrors == null) {
            logger.error("MuleMetricErrors not initialized. Call setInstance() first.");
            throw new IllegalStateException("MuleMetricErrors not initialized.");
        }
        return muleMetricErrors;
    }

    public void recordFlowError() {
        if (this.flowErrorCounter != null) {
            this.flowErrorCounter.add(1L);
        }
    }

    public void recordProcessorError() {
        if (this.processorErrorCounter != null) {
            this.processorErrorCounter.add(1L);
        }
    }
}

