/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.CustomAttributesConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.SpanGenerationConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OtelSdkConnection;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricErrors;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricLatency;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricMemoryUsage;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricSystemWorkload;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricTraffic;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.NotificationParserService;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.NotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.trace.MuleSoftTraceStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelMuleNotificationHandler {
    private static Logger logger = LoggerFactory.getLogger(OTelMuleNotificationHandler.class);
    private static MuleSoftTraceStore traceStore = new MuleSoftTraceStore();
    private OtelSdkConnection otelSdkConnection;
    private MuleConnectorConfigStore muleConnectorConfigStore;
    private final Supplier<OtelSdkConnection> sdkConnectionSupplier;

    public OTelMuleNotificationHandler(Supplier<OtelSdkConnection> s) {
        this.sdkConnectionSupplier = s;
    }

    public static MuleSoftTraceStore getMuleSoftTraceStore() {
        return traceStore;
    }

    private Tracer getTracer() {
        if (this.otelSdkConnection == null) {
            this.otelSdkConnection = this.sdkConnectionSupplier.get();
        }
        return this.otelSdkConnection.getTracer().get();
    }

    private MuleConfiguration getMuleConfiguration() {
        if (this.otelSdkConnection == null) {
            this.otelSdkConnection = this.sdkConnectionSupplier.get();
        }
        return this.otelSdkConnection.getMuleConfiguration().get();
    }

    private SpanGenerationConfig getSpanGenerationConfig() {
        if (this.otelSdkConnection == null) {
            this.otelSdkConnection = this.sdkConnectionSupplier.get();
        }
        return this.otelSdkConnection.getSpanGenerationConfig().get();
    }

    private MuleConnectorConfigStore getMuleConnectorConfigStore() {
        if (this.muleConnectorConfigStore == null) {
            if (this.otelSdkConnection == null) {
                this.otelSdkConnection = this.sdkConnectionSupplier.get();
            }
            this.muleConnectorConfigStore = MuleConnectorConfigStore.getInstance(this.getMuleConfiguration(), this.otelSdkConnection.getExpressionManager().get());
        }
        return this.muleConnectorConfigStore;
    }

    private void setCustomAttributes(SpanBuilder sb, EnrichedServerNotification n, int action) {
        if (this.otelSdkConnection == null) {
            this.otelSdkConnection = this.sdkConnectionSupplier.get();
        }
        CustomAttributesConfig cac = this.otelSdkConnection.getCustomAttributesConfig().get();
        Boolean setAttributes = true;
        switch (action) {
            case 1: {
                setAttributes = cac.getSendCustomAttributesPerFlow();
                break;
            }
            case 2: {
                setAttributes = cac.getSendCustomAttributesPerProcessor();
            }
        }
        if (setAttributes.booleanValue()) {
            cac.setAttributes(sb, this.otelSdkConnection.getExpressionManager().get(), n);
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        logger.debug("Handling flow start event");
        Instant startInstant = NotificationParserUtils.getInstantFrom((EnrichedServerNotification)notification);
        MuleMetricTraffic.getInstance().recordFlowStart();
        SpanBuilder spanBuilder = this.getTracer().spanBuilder(NotificationParserUtils.getSpanName((EnrichedServerNotification)notification)).setStartTimestamp(startInstant);
        spanBuilder.setAttribute("start.datetime", startInstant.toString());
        String workload = MuleMetricSystemWorkload.getWorkloadPercent() >= 0.0 ? String.format("%.2f %%", MuleMetricSystemWorkload.getWorkloadPercent()) : "Data not available";
        spanBuilder.setAttribute("mule.start.workload.utilization", workload);
        spanBuilder.setAttribute("mule.start.heap.usage.mbytes", String.format("%.2f MB", (double)MuleMetricMemoryUsage.getHeapMemoryUsage() / 1000000.0));
        this.setCustomAttributes(spanBuilder, (EnrichedServerNotification)notification, 1);
        NotificationParser notificationParser = NotificationParserService.getInstance().getParserFor((EnrichedServerNotification)notification).orElse(new BaseNotificationParser());
        if (!traceStore.isTracePresent(NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification))) {
            try {
                spanBuilder.setAttribute("flow.name", NotificationParserUtils.getDocName((EnrichedServerNotification)notification));
                spanBuilder.setAttribute("server.id", NotificationParserUtils.getServerId((EnrichedServerNotification)notification));
                notificationParser.startPipelineNotification((EnrichedServerNotification)notification, this.getMuleConnectorConfigStore(), spanBuilder);
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
            traceStore.startTrace(NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification), NotificationParserUtils.getFlowId((EnrichedServerNotification)notification), spanBuilder.startSpan(), startInstant);
        } else {
            try {
                spanBuilder.setAttribute("doc.name", NotificationParserUtils.getDocName((EnrichedServerNotification)notification));
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
            traceStore.addPipelineSpan(NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification), NotificationParserUtils.getFlowId((EnrichedServerNotification)notification), spanBuilder, startInstant);
        }
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        logger.debug("Handling flow end event");
        String mulesoftTraceId = NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification);
        String flowId = NotificationParserUtils.getFlowId((EnrichedServerNotification)notification);
        Instant endInstant = NotificationParserUtils.getInstantFrom((EnrichedServerNotification)notification);
        Exception flowException = notification.getException();
        String flowName = NotificationParserUtils.getDocName((EnrichedServerNotification)notification);
        Instant flowStartInstant = traceStore.getPipelineStartInstant(mulesoftTraceId, flowId);
        if (flowStartInstant != null) {
            long durationMs = Duration.between(flowStartInstant, endInstant).toMillis();
            MuleMetricLatency.getInstance().recordFlowLatency(durationMs, flowName);
        } else {
            logger.warn("Could not retrieve start instant for flow: {} ({}) to record latency.", (Object)flowName, (Object)flowId);
        }
        if (flowException != null) {
            MuleMetricErrors.getInstance().recordFlowError();
            logger.debug("Recorded flow error for flow: {}", (Object)flowName);
        }
        traceStore.endPipelineSpan(mulesoftTraceId, flowId, endInstant, flowException);
        if (traceStore.isPipelineSpansEmpty(mulesoftTraceId)) {
            traceStore.endTrace(mulesoftTraceId);
        }
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        logger.debug("Handling processor start event");
        if (NotificationParserUtils.skipParsing((EnrichedServerNotification)notification, this.getSpanGenerationConfig())) {
            return;
        }
        Instant startInstant = NotificationParserUtils.getInstantFrom((EnrichedServerNotification)notification);
        MuleMetricTraffic.getInstance().recordProcessorStart();
        NotificationParser notificationParser = NotificationParserService.getInstance().getParserFor((EnrichedServerNotification)notification).orElse(new BaseNotificationParser());
        SpanBuilder spanBuilder = this.getTracer().spanBuilder(NotificationParserUtils.getSpanName((EnrichedServerNotification)notification));
        this.setCustomAttributes(spanBuilder, (EnrichedServerNotification)notification, 2);
        notificationParser.startProcessorNotification((EnrichedServerNotification)notification, this.getMuleConnectorConfigStore(), spanBuilder);
        traceStore.addMessageProcessorSpan(NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification), NotificationParserUtils.getFlowId((EnrichedServerNotification)notification), NotificationParserUtils.getSpanId((EnrichedServerNotification)notification), spanBuilder, startInstant);
    }

    public void handleProcessorEndEvent(MessageProcessorNotification notification) {
        logger.debug("Handling end event");
        if (NotificationParserUtils.skipParsing((EnrichedServerNotification)notification, this.getSpanGenerationConfig())) {
            return;
        }
        String mulesoftTraceId = NotificationParserUtils.getMuleSoftTraceId((EnrichedServerNotification)notification);
        String flowId = NotificationParserUtils.getFlowId((EnrichedServerNotification)notification);
        String spanId = NotificationParserUtils.getSpanId((EnrichedServerNotification)notification);
        Instant endInstant = NotificationParserUtils.getInstantFrom((EnrichedServerNotification)notification);
        Exception processorException = notification.getException();
        String componentId = NotificationParserUtils.getComponentId((EnrichedServerNotification)notification);
        String docName = NotificationParserUtils.getDocName((EnrichedServerNotification)notification);
        Instant processorStartInstant = traceStore.getMessageProcessorStartInstant(mulesoftTraceId, flowId, spanId);
        if (processorStartInstant != null) {
            long durationMs = Duration.between(processorStartInstant, endInstant).toMillis();
            MuleMetricLatency.getInstance().recordProcessorLatency(durationMs, componentId, docName);
        } else {
            logger.warn("Could not retrieve start instant for processor: {} ({}) to record latency.", (Object)docName, (Object)componentId);
        }
        if (processorException != null) {
            MuleMetricErrors.getInstance().recordProcessorError();
            logger.debug("Recorded processor error for processor: {}", (Object)docName);
        }
        NotificationParser notificationParser = NotificationParserService.getInstance().getParserFor((EnrichedServerNotification)notification).orElse(new BaseNotificationParser());
        notificationParser.endProcessorNotification((EnrichedServerNotification)notification, OTelMuleNotificationHandler.getMuleSoftTraceStore());
        traceStore.endMessageProcessorSpan(mulesoftTraceId, flowId, spanId, endInstant);
    }
}

