/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import io.opentelemetry.api.trace.SpanBuilder;
import java.util.Map;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectorParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(DatabaseConnectorParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        return NotificationParserUtils.getComponentId(notification).matches("^db:.*$");
    }

    @Override
    public SpanBuilder startProcessorNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startProcessorNotification(notification, muleConnectorConfigStore, spanBuilder);
        return this.addDatabaseAttributesToSpan(notification, muleConnectorConfigStore, spanBuilder);
    }

    private SpanBuilder addDatabaseAttributesToSpan(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        Map componentParameters = (Map)NotificationParserUtils.getComponentAnnotation("{config}componentParameters", notification);
        String sql = (String)componentParameters.get("sql");
        String configRef = (String)componentParameters.get("config-ref");
        MuleConnectorConfigStore.DbConfig dbConfig = (MuleConnectorConfigStore.DbConfig)muleConnectorConfigStore.getConfig(configRef);
        try {
            spanBuilder.setAttribute("sql.statement", sql);
            spanBuilder.setAttribute("db.host", dbConfig.getHost());
            spanBuilder.setAttribute("db.port", dbConfig.getPort());
            spanBuilder.setAttribute("db.user", dbConfig.getUser());
            spanBuilder.setAttribute("db.name", dbConfig.getDbName());
            spanBuilder.setAttribute("db.connection.type", dbConfig.getConnectionType());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }
}

