/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OtelSdkConnection;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.SimpleHashMapSetter;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.OTelMuleNotificationHandler;
import org.mule.runtime.api.connection.ConnectionException;

public class OTelContextPropagator {
    private static TextMapPropagator getTextMapPropagator() throws ConnectionException {
        Supplier<ConnectionException> s = () -> new ConnectionException("Unable to get the TextMapPropagator. OTel SDK is not initialized. ");
        OtelSdkConnection osc = OtelSdkConnection.get().orElseThrow(s);
        return osc.getTextMapPropagator().get();
    }

    public static <T> Context extract(T carrier, TextMapGetter<T> textMapGetter) throws ConnectionException {
        return OTelContextPropagator.getTextMapPropagator().extract(Context.current(), carrier, textMapGetter);
    }

    public static <T> void inject(T carrier, TextMapSetter<T> textMapSetter) throws ConnectionException {
        OTelContextPropagator.getTextMapPropagator().inject(Context.current(), carrier, textMapSetter);
    }

    public static Map<String, String> makeTraceContextMapFor(String traceId) throws ConnectionException {
        Context traceContext = OTelMuleNotificationHandler.getMuleSoftTraceStore().getTraceContextFor(traceId);
        HashMap<String, String> traceContextMap = new HashMap<String, String>();
        traceContextMap.put("TRACE_TRANSACTION_ID", traceId);
        try (Scope scope = traceContext.makeCurrent();){
            OTelContextPropagator.inject(traceContextMap, new SimpleHashMapSetter());
        }
        return Collections.unmodifiableMap(traceContextMap);
    }
}

