/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.interceptor;

import org.mule.extension.otel.mule4.observablity.agent.internal.interceptor.TracingProcessorInterceptor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TracingProcessorInterceptorFactory
implements ProcessorInterceptorFactory {
    private static Logger logger = LoggerFactory.getLogger(TracingProcessorInterceptorFactory.class);
    private boolean interceptorEnabled;

    public TracingProcessorInterceptorFactory() {
        logger.info("TracingProcessorInterceptorFactory created");
    }

    public ProcessorInterceptor get() {
        return new TracingProcessorInterceptor();
    }

    public boolean intercept(ComponentLocation location) {
        this.interceptorEnabled = Boolean.parseBoolean(System.getProperty("mule.otel.processor.interceptor.enable", "false"));
        if (!this.interceptorEnabled) {
            return false;
        }
        if (this.isInterceptable(location)) {
            logger.debug("Processor at location: " + location.getLocation() + " intercepted");
            return true;
        }
        return false;
    }

    private boolean isInterceptable(ComponentLocation location) {
        boolean is = false;
        if (TracingProcessorInterceptorFactory.isFirstProcessor(location) || TracingProcessorInterceptorFactory.isProcessorType(location, "http:request") || TracingProcessorInterceptorFactory.isProcessorType(location, "mule:logger")) {
            is = true;
        }
        return is;
    }

    public static boolean isFirstProcessor(ComponentLocation location) {
        return location.getLocation().endsWith("/0");
    }

    public static boolean isProcessorType(ComponentLocation location, String processorType) {
        ComponentIdentifier componentIdentifier = location.getComponentIdentifier().getIdentifier();
        String sourceComponent = componentIdentifier.getNamespace() + ":" + componentIdentifier.getName();
        return sourceComponent.matches("^" + processorType + "$");
    }
}

