/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.metric;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMetricLatency {
    private static final Logger logger = LoggerFactory.getLogger(MuleMetricLatency.class);
    private static MuleMetricLatency muleMetricLatency;
    private DoubleHistogram flowLatencyHistogram;
    private DoubleHistogram processorLatencyHistogram;

    private MuleMetricLatency(OpenTelemetry openTelemetry) {
        logger.info("Initializing the Latency Metrics");
        Meter meter = openTelemetry.getMeter("org.mulesoft.extension.otel.mule4.observability.agent.metrics");
        this.flowLatencyHistogram = meter.histogramBuilder("mule.flow.latency").setDescription("Measures the duration of Mule flow executions.").setUnit("ms").build();
        this.processorLatencyHistogram = meter.histogramBuilder("mule.processor.latency").setDescription("Measures the duration of Mule message processor invocations.").setUnit("ms").build();
    }

    public static void setInstance(OpenTelemetry ot) {
        if (muleMetricLatency == null) {
            muleMetricLatency = new MuleMetricLatency(ot);
        }
    }

    public static MuleMetricLatency getInstance() {
        if (muleMetricLatency == null) {
            logger.error("MuleMetricLatency not initialized. Call setInstance() first.");
            throw new IllegalStateException("MuleMetricLatency not initialized.");
        }
        return muleMetricLatency;
    }

    public void recordFlowLatency(double durationMs, String flowName) {
        if (this.flowLatencyHistogram != null) {
            Attributes attributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"flow.name"), (Object)flowName);
            logger.debug("Recording flow latency: {} ms for flow: {} with attributes: {}", new Object[]{durationMs, flowName, attributes});
            this.flowLatencyHistogram.record(durationMs, attributes);
            logger.debug("Recorded flow latency: {} ms for flow: {}", (Object)durationMs, (Object)flowName);
        }
    }

    public void recordProcessorLatency(double durationMs, String componentId, String docName) {
        if (this.processorLatencyHistogram != null) {
            Attributes attributes = Attributes.builder().put(AttributeKey.stringKey((String)"component.id"), (Object)componentId).put(AttributeKey.stringKey((String)"doc.name"), (Object)docName).build();
            logger.debug("Recording processor latency: {} ms for component: {} ({}) with attributes: {}", new Object[]{durationMs, componentId, docName, attributes});
            this.processorLatencyHistogram.record(durationMs, attributes);
            logger.debug("Recorded processor latency: {} ms for component: {} ({})", new Object[]{durationMs, componentId, docName});
        }
    }
}

