/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.metric;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMetricTraffic {
    private static final Logger logger = LoggerFactory.getLogger(MuleMetricTraffic.class);
    private static MuleMetricTraffic muleMetricTraffic;
    private LongCounter flowTrafficCounter;
    private LongCounter processorTrafficCounter;

    private MuleMetricTraffic(OpenTelemetry openTelemetry) {
        logger.info("Initializing the Traffic Metrics");
        Meter meter = openTelemetry.getMeter("org.mulesoft.extension.otel.mule4.observability.agent.metrics");
        this.flowTrafficCounter = meter.counterBuilder("mule.flow.traffic.total").setDescription("Total number of Mule flow executions.").setUnit("1").build();
        this.processorTrafficCounter = meter.counterBuilder("mule.processor.traffic.total").setDescription("Total number of Mule message processor invocations.").setUnit("1").build();
    }

    public static void setInstance(OpenTelemetry ot) {
        if (muleMetricTraffic == null) {
            muleMetricTraffic = new MuleMetricTraffic(ot);
        }
    }

    public static MuleMetricTraffic getInstance() {
        if (muleMetricTraffic == null) {
            logger.error("MuleMetricTraffic not initialized. Call setInstance() first.");
            throw new IllegalStateException("MuleMetricTraffic not initialized.");
        }
        return muleMetricTraffic;
    }

    public void recordFlowStart() {
        if (this.flowTrafficCounter != null) {
            this.flowTrafficCounter.add(1L);
        }
    }

    public void recordProcessorStart() {
        if (this.processorTrafficCounter != null) {
            this.processorTrafficCounter.add(1L);
        }
    }
}

