/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.CustomAttributesConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OtelSdkConnection;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.HttpRequestAttributesGetter;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.OTelContextPropagator;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(HttpListenerParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        ComponentIdentifier sourceIdentifier = NotificationParserUtils.getSourceIdentifier(notification);
        String sourceComponent = sourceIdentifier.getNamespace() + ":" + sourceIdentifier.getName();
        int action = Integer.parseInt(notification.getAction().getIdentifier());
        return sourceComponent.equalsIgnoreCase("http:listener") && action == 1801;
    }

    @Override
    public SpanBuilder startPipelineNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startPipelineNotification(notification, muleConnectorConfigStore, spanBuilder);
        try {
            spanBuilder.setSpanKind(SpanKind.SERVER);
            spanBuilder = this.addHttpListenerAttributesToSpan(notification, spanBuilder);
            HttpRequestAttributes httpRequestAttributes = (HttpRequestAttributes)NotificationParserUtils.getMessageAttributes(notification);
            Context context = OTelContextPropagator.extract(httpRequestAttributes, new HttpRequestAttributesGetter());
            spanBuilder.setParent(context);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    private SpanBuilder addHttpListenerAttributesToSpan(EnrichedServerNotification notification, SpanBuilder spanBuilder) {
        HttpRequestAttributes httpRequestAttributes = (HttpRequestAttributes)NotificationParserUtils.getMessageAttributes(notification);
        try {
            String excludedHeaders;
            CustomAttributesConfig customAttributesConfig;
            MultiMap requestHeaders = httpRequestAttributes.getHeaders();
            spanBuilder.setAttribute("scheme", httpRequestAttributes.getScheme());
            spanBuilder.setAttribute("http.method", httpRequestAttributes.getMethod());
            spanBuilder.setAttribute("remote.address", httpRequestAttributes.getRemoteAddress());
            spanBuilder.setAttribute("request.path", httpRequestAttributes.getRequestPath());
            String requestPath = httpRequestAttributes.getRequestPath();
            String queryString = httpRequestAttributes.getQueryString();
            Object httpTarget = requestPath;
            if (queryString != null && !queryString.isEmpty()) {
                httpTarget = (String)httpTarget + "?" + queryString;
            }
            spanBuilder.setAttribute("http.target", (String)httpTarget);
            spanBuilder.setAttribute("http.route", httpRequestAttributes.getListenerPath());
            Set<Object> excludedHeadersSet = new HashSet();
            OtelSdkConnection otelSdkConnection = OtelSdkConnection.get().orElse(null);
            if (otelSdkConnection != null && (customAttributesConfig = (CustomAttributesConfig)otelSdkConnection.getCustomAttributesConfig().orElse(null)) != null && (excludedHeaders = customAttributesConfig.getExcludedHeaders()) != null) {
                excludedHeadersSet = Arrays.stream(excludedHeaders.split(",")).map(String::trim).collect(Collectors.toSet());
            }
            HashSet headersToExclude = excludedHeadersSet;
            requestHeaders.forEach((key, collection) -> {
                if (!headersToExclude.contains(key)) {
                    spanBuilder.setAttribute("headers." + key, collection);
                } else {
                    logger.debug("Excluding header from span: " + key);
                }
            });
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }
}

