/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Map;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.BaseNotificationParser;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.config.MuleConnectorConfigStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.store.trace.MuleSoftTraceStore;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.NotificationParserUtils;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequesterParser
extends BaseNotificationParser {
    private static Logger logger = LoggerFactory.getLogger(HttpRequesterParser.class);

    @Override
    public boolean canParse(EnrichedServerNotification notification) {
        return NotificationParserUtils.getComponentId(notification).equalsIgnoreCase("http:request");
    }

    @Override
    public SpanBuilder startProcessorNotification(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        super.startProcessorNotification(notification, muleConnectorConfigStore, spanBuilder);
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        return this.addHttpRequesterAttributesToSpan(notification, muleConnectorConfigStore, spanBuilder);
    }

    @Override
    public void endProcessorNotification(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        super.endProcessorNotification(notification, traceStore);
        this.addHttpResponseAttributesToSpan(notification, traceStore);
    }

    private SpanBuilder addHttpRequesterAttributesToSpan(EnrichedServerNotification notification, MuleConnectorConfigStore muleConnectorConfigStore, SpanBuilder spanBuilder) {
        Map requesterAttributes = (Map)NotificationParserUtils.getComponentAnnotation("{config}componentParameters", notification);
        String configRef = (String)requesterAttributes.get("config-ref");
        MuleConnectorConfigStore.HttpRequesterConfig httpRequesterConfig = (MuleConnectorConfigStore.HttpRequesterConfig)muleConnectorConfigStore.getConfig(configRef);
        try {
            spanBuilder.setAttribute("scheme", httpRequesterConfig.getProtocol());
            spanBuilder.setAttribute("method", (String)requesterAttributes.get("method"));
            spanBuilder.setAttribute("request.path", (String)requesterAttributes.get("path"));
            spanBuilder.setAttribute("requester.host", httpRequesterConfig.getHost());
            spanBuilder.setAttribute("requester.port", httpRequesterConfig.getPort());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return spanBuilder;
    }

    private void addHttpResponseAttributesToSpan(EnrichedServerNotification notification, MuleSoftTraceStore traceStore) {
        HttpResponseAttributes responseAttributes = (HttpResponseAttributes)NotificationParserUtils.getMessageAttributes(notification);
        Span span = traceStore.getMessageProcessorSpan(NotificationParserUtils.getMuleSoftTraceId(notification), NotificationParserUtils.getFlowId(notification), NotificationParserUtils.getSpanId(notification));
        try {
            MultiMap responseHeaders = responseAttributes.getHeaders();
            span.setAttribute("response.status.code", (long)responseAttributes.getStatusCode());
            span.setAttribute("response.reason.phrase", responseAttributes.getReasonPhrase());
            responseHeaders.forEach((key, collection) -> span.setAttribute("response.headers." + key, collection));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }
}

