/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.store.trace;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSoftTraceStore {
    private static Logger logger = LoggerFactory.getLogger(MuleSoftTraceStore.class);
    private Map<String, MuleSoftTrace> muleSoftTraces = new ConcurrentHashMap<String, MuleSoftTrace>();

    public boolean isTracePresent(String mulesoftTraceId) {
        return this.muleSoftTraces.containsKey(mulesoftTraceId);
    }

    public boolean isPipelineSpansEmpty(String mulesoftTraceId) {
        return this.muleSoftTraces.get(mulesoftTraceId).isPipelineSpansEmpty();
    }

    public void startTrace(String mulesoftTraceId, String rootSpanId, Span rootSpan, Instant startInstant) {
        this.muleSoftTraces.put(mulesoftTraceId, new MuleSoftTrace(rootSpanId, rootSpan, startInstant));
    }

    public Context getTraceContextFor(String mulesoftTraceId) {
        Context context = Context.current();
        if (this.isTracePresent(mulesoftTraceId)) {
            context = this.muleSoftTraces.get(mulesoftTraceId).getRootSpan().storeInContext(Context.current());
        }
        return context;
    }

    public void endTrace(String mulesoftTraceId) {
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.remove(mulesoftTraceId);
        muleSoftTrace.end();
    }

    public void addPipelineSpan(String mulesoftTraceId, String pipelineId, SpanBuilder spanBuilder, Instant startInstant) {
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.get(mulesoftTraceId);
        Span newSpan = spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)muleSoftTrace.getRootSpan())).startSpan();
        muleSoftTrace.putPipelineSpan(pipelineId, newSpan, startInstant);
    }

    public Instant getPipelineStartInstant(String mulesoftTraceId, String pipelineId) {
        MuleSoftTrace.PipelineSpan pipelineSpan;
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.get(mulesoftTraceId);
        if (muleSoftTrace != null && (pipelineSpan = muleSoftTrace.getPipelineSpan(pipelineId)) != null) {
            return pipelineSpan.getPipelineStartInstant();
        }
        return null;
    }

    public void endPipelineSpan(String mulesoftTraceId, String pipelineId) {
        this.endPipelineSpan(mulesoftTraceId, pipelineId, Instant.now(), null);
    }

    public void endPipelineSpan(String mulesoftTraceId, String pipelineId, Instant endInstant, Exception e) {
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.get(mulesoftTraceId);
        MuleSoftTrace.PipelineSpan pipelineSpan = muleSoftTrace.removePipelineSpan(pipelineId);
        pipelineSpan.end(endInstant, e);
    }

    public void addMessageProcessorSpan(String mulesoftTraceId, String pipelineId, String messageProcessorId, SpanBuilder spanBuilder, Instant startInstant) {
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.get(mulesoftTraceId);
        MuleSoftTrace.PipelineSpan pipelineSpan = muleSoftTrace.getPipelineSpan(pipelineId);
        if (pipelineSpan != null) {
            Span newMessageProcessorSpan = spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)pipelineSpan.getRootSpan())).startSpan();
            pipelineSpan.putSpan(messageProcessorId, newMessageProcessorSpan, startInstant);
        }
    }

    public Instant getMessageProcessorStartInstant(String mulesoftTraceId, String pipelineId, String messageProcessorId) {
        MuleSoftTrace.PipelineSpan.MessageProcessorSpan mpSpan;
        MuleSoftTrace.PipelineSpan pipelineSpan;
        MuleSoftTrace muleSoftTrace = this.muleSoftTraces.get(mulesoftTraceId);
        if (muleSoftTrace != null && (pipelineSpan = muleSoftTrace.getPipelineSpan(pipelineId)) != null && (mpSpan = pipelineSpan.getSpan(messageProcessorId)) != null) {
            return mpSpan.getProcessorStartInstant();
        }
        return null;
    }

    public Span getMessageProcessorSpan(String mulesoftTraceId, String pipelineId, String messageProcessorId) {
        return this.muleSoftTraces.get(mulesoftTraceId).getPipelineSpan(pipelineId).getSpan(messageProcessorId).getProcessorSpan();
    }

    public void endMessageProcessorSpan(String mulesoftTraceId, String pipelineId, String messageProcessorId, Instant endInstant) {
        MuleSoftTrace.PipelineSpan pipelineSpan = this.muleSoftTraces.get(mulesoftTraceId).getPipelineSpan(pipelineId);
        if (pipelineSpan != null) {
            pipelineSpan.endSpan(messageProcessorId, endInstant);
        }
    }

    private class MuleSoftTrace {
        private Span traceRootSpan;
        private Map<String, PipelineSpan> pipelineSpans = new ConcurrentHashMap<String, PipelineSpan>();

        private MuleSoftTrace(String rootSpanId, Span rootSpan, Instant startInstant) {
            this.traceRootSpan = rootSpan;
            this.pipelineSpans.put(rootSpanId, new PipelineSpan(rootSpan, startInstant));
        }

        private Span getRootSpan() {
            return this.traceRootSpan;
        }

        private boolean isPipelineSpansEmpty() {
            return this.pipelineSpans.isEmpty();
        }

        private void putPipelineSpan(String pipelineSpanId, Span pipelineSpan, Instant startInstant) {
            this.pipelineSpans.put(pipelineSpanId, new PipelineSpan(pipelineSpan, startInstant));
        }

        private PipelineSpan removePipelineSpan(String pipelineSpanId) {
            return this.pipelineSpans.remove(pipelineSpanId);
        }

        private PipelineSpan getPipelineSpan(String pipelineSpanId) {
            return this.pipelineSpans.get(pipelineSpanId);
        }

        private void end() {
            this.pipelineSpans.forEach((id, pipelineSpan) -> pipelineSpan.end());
        }

        private class PipelineSpan {
            private Span pipelineRootSpan;
            private Instant pipelineStartInstant;
            private Map<String, MessageProcessorSpan> messageProcessorSpans = new ConcurrentHashMap<String, MessageProcessorSpan>();

            private PipelineSpan(Span rootSpan, Instant startInstant) {
                this.pipelineRootSpan = rootSpan;
                this.pipelineStartInstant = startInstant;
            }

            public Instant getPipelineStartInstant() {
                return this.pipelineStartInstant;
            }

            private void putSpan(String spanId, Span span, Instant startInstant) {
                this.messageProcessorSpans.put(spanId, new MessageProcessorSpan(span, startInstant));
            }

            private MessageProcessorSpan getSpan(String spanID) {
                return this.messageProcessorSpans.get(spanID);
            }

            private Span getRootSpan() {
                return this.pipelineRootSpan;
            }

            private void endSpan(String spanId, Instant endInstant) {
                MessageProcessorSpan messageProcessorSpan = this.messageProcessorSpans.get(spanId);
                if (messageProcessorSpan != null) {
                    messageProcessorSpan.end(endInstant);
                }
            }

            private void end() {
                this.end(Instant.now(), null);
            }

            private void end(Instant endInstant, Exception e) {
                this.messageProcessorSpans.forEach((id, processorSpan) -> processorSpan.end(endInstant));
                if (this.pipelineRootSpan != null) {
                    if (e != null) {
                        this.pipelineRootSpan.setStatus(StatusCode.ERROR, e.getMessage());
                        this.pipelineRootSpan.recordException((Throwable)e);
                    }
                    this.pipelineRootSpan.setAttribute("end.datetime", endInstant.toString());
                    this.pipelineRootSpan.end(endInstant);
                }
            }

            private class MessageProcessorSpan {
                private Span processorSpan;
                private Instant processorStartInstant;

                private MessageProcessorSpan(Span span, Instant startInstant) {
                    this.processorSpan = span;
                    this.processorStartInstant = startInstant;
                }

                public Span getProcessorSpan() {
                    return this.processorSpan;
                }

                public Instant getProcessorStartInstant() {
                    return this.processorStartInstant;
                }

                public void end(Instant endInstant) {
                    this.processorSpan.end(endInstant);
                }
            }
        }
    }
}

