/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.util;

import java.time.Instant;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.MuleComponent;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.SpanGenerationConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.Constants;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;

public class NotificationParserUtils {
    public static Instant getInstantFrom(EnrichedServerNotification notification) {
        return Instant.ofEpochMilli(notification.getTimestamp());
    }

    public static ComponentIdentifier getSourceIdentifier(EnrichedServerNotification notification) {
        ComponentIdentifier sourceIdentifier = null;
        if (notification.getEvent() != null && notification.getEvent().getContext().getOriginatingLocation() != null) {
            sourceIdentifier = notification.getEvent().getContext().getOriginatingLocation().getComponentIdentifier().getIdentifier();
        }
        return sourceIdentifier;
    }

    public static String getDocName(EnrichedServerNotification notification) {
        String docName = "";
        if (notification instanceof PipelineMessageNotification) {
            docName = "name";
        } else if (notification instanceof MessageProcessorNotification) {
            docName = "doc:name";
        }
        Map annotations = (Map)NotificationParserUtils.getComponentAnnotation("{config}componentParameters", notification);
        return (String)annotations.get(docName);
    }

    public static String getFlowId(EnrichedServerNotification notification) {
        String flowId = "_" + notification.getComponent().getLocation().getRootContainerName();
        String rcn = (String)NotificationParserUtils.getComponentAnnotation("{http://www.mulesoft.org/schema/mule/parser-metadata}ROOT_CONTAINER_NAME", notification);
        if (rcn != null) {
            flowId = "_" + rcn;
        }
        return flowId;
    }

    public static String getServerId(EnrichedServerNotification notification) {
        return notification.getServerId();
    }

    public static String getSpanName(EnrichedServerNotification notification) {
        return notification.getComponent().getIdentifier().getName() + "::" + NotificationParserUtils.getDocName(notification);
    }

    public static String getSpanId(EnrichedServerNotification notification) {
        return notification.getInfo().getComponent().getLocation().getLocation();
    }

    public static String getMuleSoftTraceId(EnrichedServerNotification notification) {
        return notification.getEvent().getCorrelationId();
    }

    public static String getComponentId(EnrichedServerNotification notification) {
        ComponentIdentifier componentIdentifier = NotificationParserUtils.getComponentIdentifier(notification);
        return componentIdentifier.getNamespace() + ":" + componentIdentifier.getName();
    }

    public static ComponentIdentifier getComponentIdentifier(EnrichedServerNotification notification) {
        return (ComponentIdentifier)NotificationParserUtils.getComponentAnnotation("{config}componentIdentifier", notification);
    }

    public static MuleComponent getComponentAsMuleComponent(EnrichedServerNotification notification) {
        MuleComponent muleComponent = new MuleComponent();
        ComponentIdentifier ci = NotificationParserUtils.getComponentIdentifier(notification);
        muleComponent.setNamespace(ci.getNamespace());
        muleComponent.setName(ci.getName());
        return muleComponent;
    }

    public static boolean skipParsing(EnrichedServerNotification notification, SpanGenerationConfig spanGenerationConfig) {
        return Constants.AUTO_SKIP_LIST.contains(NotificationParserUtils.getComponentId(notification)) || !spanGenerationConfig.getGenerateMessageProcessorsSpans() || spanGenerationConfig.getBypassComponents().contains(NotificationParserUtils.getComponentAsMuleComponent(notification));
    }

    public static <T> T getMessageAttributes(EnrichedServerNotification notification) {
        return (T)notification.getEvent().getMessage().getAttributes().getValue();
    }

    public static <T> T getMessageAttributes(Event event) {
        return (T)event.getMessage().getAttributes().getValue();
    }

    public static <T> T getMessage(EnrichedServerNotification notification) {
        return (T)notification.getEvent().getMessage().getPayload().getValue();
    }

    public static <T> T getComponentAnnotation(String annotationName, EnrichedServerNotification notification) {
        return (T)notification.getComponent().getAnnotation(QName.valueOf(annotationName));
    }
}

