/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.log4j1;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import com.newrelic.logging.log4j1.NewRelicLoggingEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class NewRelicLayout
extends Layout {
    public String format(LoggingEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (IOException e) {
            return e.toString();
        }
        return sw.toString() + "\n";
    }

    private void writeToGenerator(LoggingEvent event, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("message", (Object)event.getRenderedMessage());
        generator.writeObjectField("timestamp", (Object)event.getTimeStamp());
        generator.writeObjectField("thread.name", (Object)event.getThreadName());
        generator.writeObjectField("log.level", (Object)event.getLevel().toString());
        generator.writeObjectField("logger.name", (Object)event.getLoggerName());
        if (event.getLocationInformation() != null && !event.getLocationInformation().getClassName().equals("?")) {
            generator.writeObjectField("class.name", (Object)event.getLocationInformation().getClassName());
            generator.writeObjectField("method.name", (Object)event.getLocationInformation().getMethodName());
            generator.writeObjectField("line.number", (Object)event.getLocationInformation().getLineNumber());
        }
        event.getProperties().forEach((key, value) -> {
            if (value != null) {
                try {
                    generator.writeStringField(key.toString(), value.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        if (event instanceof NewRelicLoggingEvent) {
            ((NewRelicLoggingEvent)event).getLinkedMetadata().forEach((key, value) -> {
                try {
                    generator.writeStringField(key, value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        if (event.getThrowableInformation() != null && event.getThrowableInformation().getThrowable() != null) {
            Throwable throwable = event.getThrowableInformation().getThrowable();
            generator.writeObjectField("error.class", (Object)throwable.getClass().getName());
            generator.writeObjectField("error.message", (Object)throwable.getMessage());
            generator.writeObjectField("error.stack", (Object)ExceptionUtil.getErrorStack(throwable));
        }
        generator.writeEndObject();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }
}

