/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.log4j2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

@Plugin(name="NewRelicLayout", category="Core", elementType="layout")
public class NewRelicLayout
extends AbstractStringLayout {
    static final String PLUGIN_NAME = "NewRelicLayout";

    @PluginFactory
    public static NewRelicLayout factory() {
        return new NewRelicLayout(StandardCharsets.UTF_8);
    }

    private NewRelicLayout(Charset charset) {
        super(charset);
    }

    public String toSerializable(LogEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (IOException e) {
            return e.toString();
        }
        return sw.toString() + "\n";
    }

    private void writeToGenerator(LogEvent event, JsonGenerator generator) throws IOException {
        Throwable throwable;
        Map map;
        generator.writeStartObject();
        generator.writeObjectField("message", (Object)event.getMessage().getFormattedMessage());
        generator.writeObjectField("timestamp", (Object)event.getTimeMillis());
        generator.writeObjectField("thread.name", (Object)event.getThreadName());
        generator.writeObjectField("log.level", (Object)event.getLevel().toString());
        generator.writeObjectField("logger.name", (Object)event.getLoggerName());
        if (event.isIncludeLocation() && event.getSource() != null) {
            generator.writeObjectField("class.name", (Object)event.getSource().getClassName());
            generator.writeObjectField("method.name", (Object)event.getSource().getMethodName());
            generator.writeObjectField("line.number", (Object)event.getSource().getLineNumber());
        }
        if ((map = event.getContextData().toMap()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!((String)entry.getKey()).startsWith("NewRelic:")) continue;
                String key = ((String)entry.getKey()).substring("NewRelic:".length());
                generator.writeStringField(key, (String)entry.getValue());
            }
        }
        if ((throwable = event.getThrown()) != null) {
            generator.writeObjectField("error.class", (Object)throwable.getClass().getName());
            generator.writeObjectField("error.message", (Object)throwable.getMessage());
            generator.writeObjectField("error.stack", (Object)ExceptionUtil.getErrorStack(throwable));
        }
        generator.writeEndObject();
    }
}

