/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.core;

import com.newrelic.logging.core.LogExtensionConfig;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionUtil {
    public static final int MAX_STACK_SIZE_DEFAULT = 300;

    public static String getFullStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return ExceptionUtil.getStackTraceStringFromFramesArray(ExceptionUtils.getStackFrames((Throwable)throwable));
    }

    public static String transformLogbackStackTraceString(String trace) {
        if (trace == null || trace.length() == 0) {
            return null;
        }
        return ExceptionUtil.getStackTraceStringFromFramesArray(trace.split("\n"));
    }

    private static String getStackTraceStringFromFramesArray(String[] frames) {
        int maxStackSize = LogExtensionConfig.getMaxStackSize();
        frames = frames.length > maxStackSize ? Arrays.copyOfRange(frames, 1, maxStackSize + 1) : Arrays.copyOfRange(frames, 1, frames.length);
        return String.join((CharSequence)"\n", frames).replace("\tat", "  at") + "\n";
    }
}

