/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.log4j2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import com.newrelic.logging.core.LogExtensionConfig;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

@Plugin(name="NewRelicLayout", category="Core", elementType="layout")
public class NewRelicLayout
extends AbstractStringLayout {
    static final String PLUGIN_NAME = "NewRelicLayout";

    @PluginFactory
    public static NewRelicLayout factory() {
        return new NewRelicLayout(StandardCharsets.UTF_8);
    }

    private NewRelicLayout(Charset charset) {
        super(charset);
    }

    public String toSerializable(LogEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (IOException e) {
            return e.toString();
        }
        return sw + "\n";
    }

    private void writeToGenerator(LogEvent event, JsonGenerator generator) throws IOException {
        Map map;
        generator.writeStartObject();
        generator.writeObjectField("message", (Object)event.getMessage().getFormattedMessage());
        generator.writeObjectField("timestamp", (Object)event.getTimeMillis());
        generator.writeObjectField("thread.name", (Object)event.getThreadName());
        generator.writeObjectField("log.level", (Object)event.getLevel().toString());
        generator.writeObjectField("logger.name", (Object)event.getLoggerName());
        if (event.isIncludeLocation() && event.getSource() != null) {
            generator.writeObjectField("class.name", (Object)event.getSource().getClassName());
            generator.writeObjectField("method.name", (Object)event.getSource().getMethodName());
            generator.writeObjectField("line.number", (Object)event.getSource().getLineNumber());
        }
        if ((map = event.getContextData().toMap()) != null) {
            Map<String, Set<String>> multiValueMap = this.createMultiValueMapOfContextData(map);
            for (Map.Entry<String, Set<String>> entry : multiValueMap.entrySet()) {
                String[] values = entry.getValue().toArray(new String[0]);
                if (values.length > 1) {
                    generator.writeArrayFieldStart(entry.getKey());
                    generator.writeArray(values, 0, values.length);
                    generator.writeEndArray();
                    continue;
                }
                generator.writeStringField(entry.getKey(), values[0]);
            }
            Throwable throwable = event.getThrown();
            if (throwable != null) {
                generator.writeObjectField("error.class", (Object)throwable.getClass().getName());
                generator.writeObjectField("error.message", (Object)throwable.getMessage());
                generator.writeObjectField("error.stack", (Object)ExceptionUtil.getFullStackTrace(throwable));
            }
            generator.writeEndObject();
        }
    }

    private Map<String, Set<String>> createMultiValueMapOfContextData(Map<String, String> map) {
        HashMap<String, Set<String>> multiValueMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().startsWith("NewRelic:")) {
                String key = entry.getKey().substring("NewRelic:".length());
                multiValueMap.computeIfAbsent(key, k -> new HashSet()).add(entry.getValue());
                continue;
            }
            if (!LogExtensionConfig.shouldAddMDC()) continue;
            multiValueMap.computeIfAbsent("context." + entry.getKey(), k -> new HashSet()).add(entry.getValue());
        }
        return multiValueMap;
    }
}

