/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.core;

public class ExceptionUtil {
    public static final int MAX_STACK_SIZE = 10;

    public static String getErrorStack(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StackTraceElement[] stack = throwable.getStackTrace();
        return ExceptionUtil.getErrorStack(stack);
    }

    public static String getErrorStack(StackTraceElement[] stack) {
        if (stack == null || stack.length == 0) {
            return null;
        }
        StringBuilder stackBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(10, stack.length); ++i) {
            stackBuilder.append("  at " + stack[i].toString() + "\n");
        }
        return stackBuilder.toString();
    }
}

