/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

public class NewRelicJsonLayout
extends LayoutBase<ILoggingEvent> {
    public String doLayout(ILoggingEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (Throwable ignored) {
            return event.getFormattedMessage();
        }
        sw.append('\n');
        return sw.toString();
    }

    private void writeToGenerator(ILoggingEvent event, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("message", event.getFormattedMessage());
        generator.writeNumberField("timestamp", event.getTimeStamp());
        generator.writeStringField("log.level", event.getLevel().toString());
        generator.writeStringField("logger.name", event.getLoggerName());
        generator.writeStringField("thread.name", event.getThreadName());
        if (event.hasCallerData()) {
            StackTraceElement element = event.getCallerData()[event.getCallerData().length - 1];
            generator.writeStringField("class.name", element.getClassName());
            generator.writeStringField("method.name", element.getMethodName());
            generator.writeNumberField("line.number", element.getLineNumber());
        }
        Map mdcPropertyMap = event.getMDCPropertyMap();
        for (Map.Entry entry : mdcPropertyMap.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty()) continue;
            generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
        IThrowableProxy proxy = event.getThrowableProxy();
        if (proxy != null) {
            generator.writeObjectField("error.class", (Object)proxy.getClassName());
            generator.writeObjectField("error.message", (Object)proxy.getMessage());
            StackTraceElementProxy[] stackProxy = proxy.getStackTraceElementProxyArray();
            if (stackProxy != null && stackProxy.length > 0) {
                ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(10);
                for (int i = 0; i < 10 && i < stackProxy.length; ++i) {
                    elements.add(stackProxy[i].getStackTraceElement());
                }
                generator.writeObjectField("error.stack", (Object)ExceptionUtil.getErrorStack(elements.toArray(new StackTraceElement[0])));
            }
        }
        generator.writeEndObject();
    }
}

