/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import com.newrelic.logging.logback.CustomArgument;
import com.newrelic.logging.logback.JsonFactoryProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

public class NewRelicJsonLayout
extends LayoutBase<ILoggingEvent> {
    private final Integer maxStackSize;

    public NewRelicJsonLayout() {
        this(10);
    }

    public NewRelicJsonLayout(Integer maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public String doLayout(ILoggingEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = JsonFactoryProvider.getInstance().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (Throwable ignored) {
            return event.getFormattedMessage();
        }
        sw.append('\n');
        return sw.toString();
    }

    private void writeToGenerator(ILoggingEvent event, JsonGenerator generator) throws IOException {
        IThrowableProxy iThrowableProxy;
        generator.writeStartObject();
        generator.writeStringField("message", event.getFormattedMessage());
        generator.writeNumberField("timestamp", event.getTimeStamp());
        generator.writeStringField("log.level", event.getLevel().toString());
        generator.writeStringField("logger.name", event.getLoggerName());
        generator.writeStringField("thread.name", event.getThreadName());
        if (event.hasCallerData()) {
            StackTraceElement element = event.getCallerData()[event.getCallerData().length - 1];
            generator.writeStringField("class.name", element.getClassName());
            generator.writeStringField("method.name", element.getMethodName());
            generator.writeNumberField("line.number", element.getLineNumber());
        }
        Map mdcPropertyMap = event.getMDCPropertyMap();
        for (Map.Entry entry : mdcPropertyMap.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty()) continue;
            generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
        Object[] customArgumentArray = event.getArgumentArray();
        if (customArgumentArray != null) {
            for (Object oneCustomArgumentObject : customArgumentArray) {
                if (!(oneCustomArgumentObject instanceof CustomArgument)) continue;
                CustomArgument customArgument = (CustomArgument)oneCustomArgumentObject;
                generator.writeStringField(customArgument.getKey(), customArgument.getValue());
            }
        }
        if ((iThrowableProxy = event.getThrowableProxy()) != null) {
            generator.writeObjectField("error.class", (Object)iThrowableProxy.getClassName());
            generator.writeObjectField("error.message", (Object)iThrowableProxy.getMessage());
            StackTraceElementProxy[] stackProxy = iThrowableProxy.getStackTraceElementProxyArray();
            if (stackProxy != null && stackProxy.length > 0) {
                ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(this.maxStackSize);
                for (int i = 0; i < this.maxStackSize && i < stackProxy.length; ++i) {
                    elements.add(stackProxy[i].getStackTraceElement());
                }
                generator.writeObjectField("error.stack", (Object)ExceptionUtil.getErrorStack(elements.toArray(new StackTraceElement[0]), this.maxStackSize));
            }
        }
        generator.writeEndObject();
    }
}

