/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import com.newrelic.logging.core.LogExtensionConfig;
import com.newrelic.logging.logback.CustomArgument;
import com.newrelic.logging.logback.JsonFactoryProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class NewRelicJsonLayout
extends LayoutBase<ILoggingEvent> {
    private final Integer maxStackSize;

    public NewRelicJsonLayout() {
        this(LogExtensionConfig.getMaxStackSize());
    }

    public NewRelicJsonLayout(Integer maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public String doLayout(ILoggingEvent event) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = JsonFactoryProvider.getInstance().createGenerator((Writer)sw);){
            this.writeToGenerator(event, generator);
        }
        catch (Throwable ignored) {
            return event.getFormattedMessage();
        }
        sw.append('\n');
        return sw.toString();
    }

    private void writeToGenerator(ILoggingEvent event, JsonGenerator generator) throws IOException {
        IThrowableProxy iThrowableProxy;
        Object[] customArgumentArray;
        generator.writeStartObject();
        generator.writeStringField("message", event.getFormattedMessage());
        generator.writeNumberField("timestamp", event.getTimeStamp());
        generator.writeStringField("log.level", event.getLevel().toString());
        generator.writeStringField("logger.name", event.getLoggerName());
        generator.writeStringField("thread.name", event.getThreadName());
        if (event.hasCallerData()) {
            StackTraceElement element = event.getCallerData()[event.getCallerData().length - 1];
            generator.writeStringField("class.name", element.getClassName());
            generator.writeStringField("method.name", element.getMethodName());
            generator.writeNumberField("line.number", element.getLineNumber());
        }
        Map mdcPropertyMap = event.getMDCPropertyMap();
        for (Map.Entry entry : mdcPropertyMap.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty()) continue;
            if (((String)entry.getKey()).startsWith("NewRelic:")) {
                String key = ((String)entry.getKey()).substring("NewRelic:".length());
                generator.writeStringField(key, (String)entry.getValue());
                continue;
            }
            if (!LogExtensionConfig.shouldAddMDC()) continue;
            generator.writeStringField("context." + (String)entry.getKey(), (String)entry.getValue());
        }
        if (event.getMarker() != null) {
            generator.writeStringField("marker", event.getMarker().getName());
        }
        if ((customArgumentArray = event.getArgumentArray()) != null) {
            for (Object oneCustomArgumentObject : customArgumentArray) {
                if (!(oneCustomArgumentObject instanceof CustomArgument)) continue;
                CustomArgument customArgument = (CustomArgument)oneCustomArgumentObject;
                generator.writeStringField(customArgument.getKey(), customArgument.getValue());
            }
        }
        if ((iThrowableProxy = event.getThrowableProxy()) != null) {
            generator.writeObjectField("error.class", (Object)iThrowableProxy.getClassName());
            generator.writeObjectField("error.message", (Object)iThrowableProxy.getMessage());
            generator.writeObjectField("error.stack", (Object)ExceptionUtil.transformLogbackStackTraceString(ThrowableProxyUtil.asString((IThrowableProxy)iThrowableProxy)));
        }
        generator.writeEndObject();
    }
}

