/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.logback;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.newrelic.api.agent.Agent;
import com.newrelic.api.agent.NewRelic;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.MDC;
import org.slf4j.helpers.NOPMDCAdapter;

public class NewRelicAsyncAppender
extends AsyncAppender {
    public static final String NEW_RELIC_PREFIX = "NewRelic:";
    public static Supplier<Agent> agentSupplier = NewRelic::getAgent;

    protected void preprocess(ILoggingEvent eventObject) {
        Map linkingMetadata = agentSupplier.get().getLinkingMetadata();
        if (!IsNoOpMDCHolder.isNoOpMDC) {
            for (Map.Entry entry : linkingMetadata.entrySet()) {
                MDC.put((String)(NEW_RELIC_PREFIX + (String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
        super.preprocess(eventObject);
        if (IsNoOpMDCHolder.isNoOpMDC) {
            for (Map.Entry entry : linkingMetadata.entrySet()) {
                eventObject.getMDCPropertyMap().put(NEW_RELIC_PREFIX + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    static class IsNoOpMDCHolder {
        static boolean isNoOpMDC = MDC.getMDCAdapter() instanceof NOPMDCAdapter;

        IsNoOpMDCHolder() {
        }
    }
}

