/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.newrelic.NewRelicReporterBuilder;
import com.codahale.metrics.newrelic.transformer.CounterTransformer;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.GaugeTransformer;
import com.codahale.metrics.newrelic.transformer.HistogramTransformer;
import com.codahale.metrics.newrelic.transformer.MeterTransformer;
import com.codahale.metrics.newrelic.transformer.TimerTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(NewRelicReporter.class);
    private static final String implementationVersion;
    private final TimeTracker timeTracker;
    private final TelemetryClient sender;
    private final Attributes commonAttributes;
    private final HistogramTransformer histogramTransformer;
    private final GaugeTransformer gaugeTransformer;
    private final CounterTransformer counterTransformer;
    private final MeterTransformer meterTransformer;
    private final TimerTransformer timerTransformer;
    private final MetricRegistry registry;

    NewRelicReporter(TimeTracker timeTracker, MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, TelemetryClient sender, Attributes commonAttributes, HistogramTransformer histogramTransformer, GaugeTransformer gaugeTransformer, CounterTransformer counterTransformer, MeterTransformer meterTransformer, TimerTransformer timerTransformer, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, name, filter, rateUnit, durationUnit, null, true, disabledMetricAttributes);
        this.registry = registry;
        this.timeTracker = timeTracker;
        this.sender = sender;
        this.commonAttributes = commonAttributes == null ? new Attributes() : commonAttributes.copy();
        this.commonAttributes.put("instrumentation.provider", "dropwizard");
        this.commonAttributes.put("collector.name", "dropwizard-metrics-newrelic");
        this.commonAttributes.put("collector.version", implementationVersion);
        this.histogramTransformer = histogramTransformer;
        this.gaugeTransformer = gaugeTransformer;
        this.counterTransformer = counterTransformer;
        this.meterTransformer = meterTransformer;
        this.timerTransformer = timerTransformer;
    }

    public synchronized void start(long initialDelay, long period, TimeUnit unit) {
        this.allMetricTransformers().forEach(arg_0 -> ((MetricRegistry)this.registry).addListener(arg_0));
        LOG.info("New Relic Reporter: Version " + implementationVersion + " is starting");
        super.start(initialDelay, period, unit);
    }

    public void stop() {
        this.allMetricTransformers().forEach(arg_0 -> ((MetricRegistry)this.registry).removeListener(arg_0));
        super.stop();
    }

    private Stream<DropWizardMetricTransformer<? extends Metric>> allMetricTransformers() {
        return Stream.of(this.histogramTransformer, this.meterTransformer, this.timerTransformer, this.gaugeTransformer, this.counterTransformer);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Stream[] streamArray = new Stream[5];
        streamArray[0] = this.transform(gauges, this.gaugeTransformer::transform);
        streamArray[1] = this.transform(histograms, this.histogramTransformer::transform);
        streamArray[2] = this.transform(counters, this.counterTransformer::transform);
        streamArray[3] = this.transform(meters, this.meterTransformer::transform);
        streamArray[4] = this.transform(timers, this.timerTransformer::transform);
        List metrics = Stream.of(streamArray).flatMap(Function.identity()).collect(Collectors.toList());
        this.sender.sendBatch(new MetricBatch(metrics, this.commonAttributes));
        this.timeTracker.tick();
    }

    public void close() {
        super.close();
        this.sender.shutdown();
    }

    private <T> Stream<com.newrelic.telemetry.metrics.Metric> transform(Map<String, T> metrics, BiFunction<String, T, Collection<com.newrelic.telemetry.metrics.Metric>> supplier) {
        return metrics.entrySet().stream().flatMap(entry -> ((Collection)supplier.apply((String)entry.getKey(), entry.getValue())).stream());
    }

    public static NewRelicReporterBuilder build(MetricRegistry registry, MetricBatchSender sender) {
        return NewRelicReporterBuilder.forRegistry(registry, sender);
    }

    static {
        Package thisPackage = NewRelicReporter.class.getPackage();
        implementationVersion = Optional.ofNullable(thisPackage.getImplementationVersion()).orElse("Unknown Version");
    }
}

