/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.newrelic.NewRelicReporter;
import com.codahale.metrics.newrelic.transformer.CounterTransformer;
import com.codahale.metrics.newrelic.transformer.GaugeTransformer;
import com.codahale.metrics.newrelic.transformer.HistogramTransformer;
import com.codahale.metrics.newrelic.transformer.MeterTransformer;
import com.codahale.metrics.newrelic.transformer.TimerTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class NewRelicReporterBuilder {
    private final MetricRegistry registry;
    private final MetricBatchSender metricBatchSender;
    private String name = "newRelicReporter";
    private MetricFilter filter = MetricFilter.ALL;
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private Attributes commonAttributes = new Attributes();
    private Set<MetricAttribute> disabledMetricAttributes = Collections.emptySet();
    private MetricNameCustomizer nameCustomizer = MetricNameCustomizer.DEFAULT;
    private MetricAttributesCustomizer attributeCustomizer = MetricAttributesCustomizer.DEFAULT;

    public static NewRelicReporterBuilder forRegistry(MetricRegistry registry, MetricBatchSender metricBatchSender) {
        return new NewRelicReporterBuilder(registry, metricBatchSender);
    }

    private NewRelicReporterBuilder(MetricRegistry registry, MetricBatchSender newRelicSender) {
        this.registry = registry;
        this.metricBatchSender = newRelicSender;
    }

    public NewRelicReporterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public NewRelicReporterBuilder filter(MetricFilter filter) {
        this.filter = filter;
        return this;
    }

    public NewRelicReporterBuilder rateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public NewRelicReporterBuilder durationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    public NewRelicReporterBuilder commonAttributes(Attributes commonAttributes) {
        this.commonAttributes = commonAttributes;
        return this;
    }

    public NewRelicReporterBuilder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
        this.disabledMetricAttributes = disabledMetricAttributes;
        return this;
    }

    public NewRelicReporterBuilder metricNameCustomizer(MetricNameCustomizer nameCustomizer) {
        this.nameCustomizer = nameCustomizer;
        return this;
    }

    public NewRelicReporterBuilder metricAttributeCustomizer(MetricAttributesCustomizer attributeCustomizer) {
        this.attributeCustomizer = attributeCustomizer;
        return this;
    }

    public NewRelicReporter build() {
        long rateFactor = this.rateUnit.toSeconds(1L);
        double durationFactor = this.durationUnit.toNanos(1L);
        Predicate<MetricAttribute> metricAttributePredicate = attr -> !this.disabledMetricAttributes.contains(attr);
        TimeTracker timeTracker = new TimeTracker(Clock.defaultClock());
        MeterTransformer meterTransformer = MeterTransformer.build(timeTracker, rateFactor, metricAttributePredicate, this.nameCustomizer, this.attributeCustomizer);
        TimerTransformer timerTransformer = TimerTransformer.build(timeTracker, rateFactor, durationFactor, metricAttributePredicate, this.nameCustomizer, this.attributeCustomizer);
        GaugeTransformer gaugeTransformer = new GaugeTransformer(this.nameCustomizer, this.attributeCustomizer);
        CounterTransformer counterTransformer = new CounterTransformer(this.nameCustomizer, this.attributeCustomizer);
        HistogramTransformer histogramTransformer = HistogramTransformer.build(timeTracker, this.nameCustomizer, this.attributeCustomizer);
        return new NewRelicReporter(timeTracker, this.registry, this.name, this.filter, this.rateUnit, this.durationUnit, new TelemetryClient(this.metricBatchSender, null, null, null), this.commonAttributes, histogramTransformer, gaugeTransformer, counterTransformer, meterTransformer, timerTransformer, this.disabledMetricAttributes);
    }
}

