/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic;

import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.newrelic.NewRelicReporterBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.OkHttpPoster;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import io.dropwizard.metrics.BaseReporterFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="newrelic")
public class NewRelicReporterFactory
extends BaseReporterFactory {
    @JsonProperty
    private String apiKey = null;
    @JsonProperty
    private String overrideUri = null;
    @JsonProperty
    private Map<String, Object> commonAttributes = null;
    @Valid
    @NotNull
    @JsonProperty
    private EnumSet<MetricAttribute> disabledMetricAttributes = EnumSet.noneOf(MetricAttribute.class);

    @NotNull
    public ScheduledReporter build(MetricRegistry registry) {
        MetricBatchSenderFactory factory = MetricBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new);
        SenderConfiguration.SenderConfigurationBuilder config = factory.configureWith(this.apiKey);
        config = this.configureEndpoint(config);
        Attributes attributes = new Attributes();
        if (this.commonAttributes != null) {
            for (Map.Entry<String, Object> entry : this.commonAttributes.entrySet()) {
                if (entry.getValue() instanceof String) {
                    attributes.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Number) {
                    attributes.put(entry.getKey(), (Number)entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof Boolean)) continue;
                attributes.put(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
            }
        }
        MetricBatchSender metricBatchSender = MetricBatchSender.create((SenderConfiguration)config.build());
        return NewRelicReporterBuilder.forRegistry(registry, metricBatchSender).durationUnit(this.getDurationUnit()).rateUnit(this.getRateUnit()).filter(this.getFilter()).commonAttributes(attributes).disabledMetricAttributes(this.disabledMetricAttributes).build();
    }

    private SenderConfiguration.SenderConfigurationBuilder configureEndpoint(SenderConfiguration.SenderConfigurationBuilder config) {
        if (this.overrideUri == null) {
            return config;
        }
        URI uri = URI.create(this.overrideUri);
        try {
            return config.endpoint(uri.toURL());
        }
        catch (MalformedURLException t) {
            throw new IllegalArgumentException(t.getMessage(), t);
        }
    }
}

