/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class CounterTransformer
implements DropWizardMetricTransformer<Counter> {
    private final Clock clock;
    private final MetricNameCustomizer nameCustomizer;
    private final MetricAttributesCustomizer attributeCustomizer;

    public CounterTransformer() {
        this(Clock.defaultClock());
    }

    public CounterTransformer(MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this(Clock.defaultClock(), nameCustomizer, attributeCustomizer);
    }

    CounterTransformer(Clock clock) {
        this(clock, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    CounterTransformer(Clock clock, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this.clock = clock;
        this.nameCustomizer = Objects.requireNonNull(nameCustomizer);
        this.attributeCustomizer = Objects.requireNonNull(attributeCustomizer);
    }

    @Override
    public Collection<com.newrelic.telemetry.metrics.Metric> transform(String name, Counter counter) {
        String customizedName = this.nameCustomizer.customizeMetricName(name);
        Attributes customizedAttributes = this.attributeCustomizer.customizeMetricAttributes(name, (Metric)counter, new Attributes());
        return Collections.singleton(new Gauge(customizedName, (double)counter.getCount(), this.clock.getTime(), customizedAttributes));
    }
}

