/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.newrelic.telemetry.Attributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeTransformer
implements DropWizardMetricTransformer<Gauge> {
    private static final Logger LOG = LoggerFactory.getLogger(GaugeTransformer.class);
    private final Clock clock;
    private final MetricNameCustomizer nameCustomizer;
    private final MetricAttributesCustomizer attributeCustomizer;

    public GaugeTransformer() {
        this(MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    public GaugeTransformer(MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this(Clock.defaultClock(), nameCustomizer, attributeCustomizer);
    }

    public GaugeTransformer(Clock clock) {
        this(clock, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    public GaugeTransformer(Clock clock, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this.clock = clock;
        this.nameCustomizer = Objects.requireNonNull(nameCustomizer);
        this.attributeCustomizer = Objects.requireNonNull(attributeCustomizer);
    }

    @Override
    public Collection<com.newrelic.telemetry.metrics.Metric> transform(String name, Gauge gauge) {
        String customizedName = this.nameCustomizer.customizeMetricName(name);
        Attributes customizedAttributes = this.attributeCustomizer.customizeMetricAttributes(name, (Metric)gauge, new Attributes());
        long timestamp = this.clock.getTime();
        Object gaugeValue = gauge.getValue();
        if (gaugeValue == null) {
            LOG.debug("Ignoring gauge with null value. Gauge name: {}, Gauge attributes: {}", (Object)customizedName, (Object)customizedAttributes);
            return Collections.emptySet();
        }
        if (gaugeValue instanceof Number) {
            com.newrelic.telemetry.metrics.Gauge metric = new com.newrelic.telemetry.metrics.Gauge(customizedName, ((Number)gaugeValue).doubleValue(), timestamp, customizedAttributes);
            return Collections.singleton(metric);
        }
        LOG.debug("Ignoring gauge [name: {}, Attributes: {}] with value of type {} (non-numeric gauges are unsupported)", new Object[]{customizedName, customizedAttributes, gaugeValue.getClass().getName()});
        return Collections.emptySet();
    }
}

