/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.codahale.metrics.newrelic.transformer.interfaces.CountingTransformer;
import com.codahale.metrics.newrelic.transformer.interfaces.SamplingTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HistogramTransformer
implements DropWizardMetricTransformer<Histogram> {
    static final Supplier<Attributes> ATTRIBUTES_SUPPLIER = Attributes::new;
    private final CountingTransformer countingTransformer;
    private final SamplingTransformer samplingTransformer;
    private final MetricNameCustomizer nameCustomizer;
    private final MetricAttributesCustomizer attributeCustomizer;

    public static HistogramTransformer build(TimeTracker timeTracker) {
        return HistogramTransformer.build(timeTracker, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    public static HistogramTransformer build(TimeTracker timeTracker, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        return new HistogramTransformer(new CountingTransformer(timeTracker), new SamplingTransformer(timeTracker, 1.0), nameCustomizer, attributeCustomizer);
    }

    HistogramTransformer(CountingTransformer countingTransformer, SamplingTransformer samplingTransformer, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this.countingTransformer = countingTransformer;
        this.samplingTransformer = samplingTransformer;
        this.nameCustomizer = Objects.requireNonNull(nameCustomizer);
        this.attributeCustomizer = Objects.requireNonNull(attributeCustomizer);
    }

    HistogramTransformer(CountingTransformer countingTransformer, SamplingTransformer samplingTransformer) {
        this(countingTransformer, samplingTransformer, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    @Override
    public Collection<com.newrelic.telemetry.metrics.Metric> transform(String name, Histogram histogram) {
        String customizedName = this.nameCustomizer.customizeMetricName(name);
        Supplier<Attributes> customizedAttributeSupplier = () -> this.attributeCustomizer.customizeMetricAttributes(name, (Metric)histogram, ATTRIBUTES_SUPPLIER.get());
        Collection<com.newrelic.telemetry.metrics.Metric> counts = this.countingTransformer.transform(customizedName, (Counting)histogram, customizedAttributeSupplier);
        return Stream.concat(counts.stream(), this.samplingTransformer.transform(customizedName, (Sampling)histogram, customizedAttributeSupplier).stream()).collect(Collectors.toSet());
    }

    @Override
    public void onHistogramRemoved(String name) {
        this.countingTransformer.remove(this.nameCustomizer.customizeMetricName(name));
    }
}

