/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.codahale.metrics.newrelic.transformer.interfaces.CountingTransformer;
import com.codahale.metrics.newrelic.transformer.interfaces.MeteredTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MeterTransformer
implements DropWizardMetricTransformer<Meter> {
    static final Supplier<Attributes> BASE_ATTRIBUTES = Attributes::new;
    private final MetricNameCustomizer nameCustomizer;
    private final MetricAttributesCustomizer attributeCustomizer;
    private final MeteredTransformer meteredTransformer;
    private final CountingTransformer countingTransformer;

    public static MeterTransformer build(TimeTracker timeTracker, long rateFactor, Predicate<MetricAttribute> metricAttributePredicate, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        return new MeterTransformer(new MeteredTransformer(rateFactor, metricAttributePredicate), new CountingTransformer(timeTracker), nameCustomizer, attributeCustomizer);
    }

    public static MeterTransformer build(TimeTracker timeTracker, long rateFactor, Predicate<MetricAttribute> metricAttributePredicate) {
        return MeterTransformer.build(timeTracker, rateFactor, metricAttributePredicate, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    MeterTransformer(MeteredTransformer meteredTransformer, CountingTransformer countingTransformer, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this.meteredTransformer = meteredTransformer;
        this.countingTransformer = countingTransformer;
        this.nameCustomizer = nameCustomizer;
        this.attributeCustomizer = attributeCustomizer;
    }

    MeterTransformer(MeteredTransformer meteredTransformer, CountingTransformer countingTransformer) {
        this(meteredTransformer, countingTransformer, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    @Override
    public Collection<com.newrelic.telemetry.metrics.Metric> transform(String name, Meter meter) {
        String customizedName = this.nameCustomizer.customizeMetricName(name);
        Supplier<Attributes> customizedAttributeSupplier = () -> this.attributeCustomizer.customizeMetricAttributes(name, (Metric)meter, BASE_ATTRIBUTES.get());
        return Stream.concat(this.countingTransformer.transform(customizedName, (Counting)meter, customizedAttributeSupplier).stream(), this.meteredTransformer.transform(customizedName, (Metered)meter, customizedAttributeSupplier).stream()).collect(Collectors.toSet());
    }

    @Override
    public void onMeterRemoved(String name) {
        this.countingTransformer.remove(this.nameCustomizer.customizeMetricName(name));
    }
}

