/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Timer;
import com.codahale.metrics.newrelic.transformer.DropWizardMetricTransformer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricAttributesCustomizer;
import com.codahale.metrics.newrelic.transformer.customizer.MetricNameCustomizer;
import com.codahale.metrics.newrelic.transformer.interfaces.CountingTransformer;
import com.codahale.metrics.newrelic.transformer.interfaces.MeteredTransformer;
import com.codahale.metrics.newrelic.transformer.interfaces.SamplingTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimerTransformer
implements DropWizardMetricTransformer<Timer> {
    static final Supplier<Attributes> ATTRIBUTES_SUPPLIER = Attributes::new;
    private final SamplingTransformer samplingTransformer;
    private final MeteredTransformer meteredTransformer;
    private final CountingTransformer countingTransformer;
    private final MetricNameCustomizer nameCustomizer;
    private final MetricAttributesCustomizer attributeCustomizer;

    public static TimerTransformer build(TimeTracker timeTracker, long rateFactor, double scaleFactor, Predicate<MetricAttribute> metricAttributePredicate, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        return new TimerTransformer(new SamplingTransformer(timeTracker, scaleFactor), new MeteredTransformer(rateFactor, metricAttributePredicate), new CountingTransformer(timeTracker), nameCustomizer, attributeCustomizer);
    }

    TimerTransformer(SamplingTransformer samplingTransformer, MeteredTransformer meteredTransformer, CountingTransformer countingTransformer) {
        this(samplingTransformer, meteredTransformer, countingTransformer, MetricNameCustomizer.DEFAULT, MetricAttributesCustomizer.DEFAULT);
    }

    TimerTransformer(SamplingTransformer samplingTransformer, MeteredTransformer meteredTransformer, CountingTransformer countingTransformer, MetricNameCustomizer nameCustomizer, MetricAttributesCustomizer attributeCustomizer) {
        this.samplingTransformer = samplingTransformer;
        this.meteredTransformer = meteredTransformer;
        this.countingTransformer = countingTransformer;
        this.nameCustomizer = nameCustomizer;
        this.attributeCustomizer = attributeCustomizer;
    }

    @Override
    public Collection<com.newrelic.telemetry.metrics.Metric> transform(String name, Timer timer) {
        String customizedName = this.nameCustomizer.customizeMetricName(name);
        Supplier<Attributes> customizedAttributeSupplier = () -> this.attributeCustomizer.customizeMetricAttributes(name, (Metric)timer, ATTRIBUTES_SUPPLIER.get());
        return Stream.of(this.samplingTransformer.transform(customizedName, (Sampling)timer, customizedAttributeSupplier), this.meteredTransformer.transform(customizedName, (Metered)timer, customizedAttributeSupplier), this.countingTransformer.transform(customizedName, (Counting)timer, customizedAttributeSupplier)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void onTimerRemoved(String name) {
        this.countingTransformer.remove(this.nameCustomizer.customizeMetricName(name));
    }
}

