/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer.interfaces;

import com.codahale.metrics.Counting;
import com.codahale.metrics.newrelic.transformer.interfaces.DropWizardComponentTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Count;
import com.newrelic.telemetry.metrics.Metric;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class CountingTransformer
implements DropWizardComponentTransformer<Counting> {
    private final TimeTracker timeTracker;
    private final Map<String, Long> previousValues = new ConcurrentHashMap<String, Long>();

    public CountingTransformer(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    @Override
    public Collection<Metric> transform(String name, Counting counting, Supplier<Attributes> baseAttributes) {
        long count = counting.getCount();
        Long previousValue = this.previousValues.put(name, count);
        if (previousValue != null && previousValue <= count) {
            count -= previousValue.longValue();
        }
        return Collections.singleton(new Count(name, (double)count, this.timeTracker.getPreviousTime(), this.timeTracker.getCurrentTime(), baseAttributes.get()));
    }

    public void remove(String metricName) {
        this.previousValues.remove(metricName);
    }
}

