/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer.interfaces;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.newrelic.transformer.interfaces.DropWizardComponentTransformer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MeteredTransformer
implements DropWizardComponentTransformer<Metered> {
    private final Clock clock;
    private final long rateFactor;
    private final Predicate<MetricAttribute> metricAttributePredicate;

    public MeteredTransformer(long rateFactor, Predicate<MetricAttribute> metricAttributePredicate) {
        this(Clock.defaultClock(), rateFactor, metricAttributePredicate);
    }

    MeteredTransformer(Clock clock, long rateFactor, Predicate<MetricAttribute> metricAttributePredicate) {
        this.clock = clock;
        this.rateFactor = rateFactor;
        this.metricAttributePredicate = metricAttributePredicate;
    }

    @Override
    public Collection<Metric> transform(String name, Metered metered, Supplier<Attributes> baseAttributes) {
        long timestamp = this.clock.getTime();
        String ratesName = name + ".rates";
        Gauge mean = this.makeGauge(ratesName, timestamp, this.convertRate(metered.getMeanRate()), MetricAttribute.MEAN_RATE, baseAttributes);
        Gauge oneMinuteRate = this.makeGauge(ratesName, timestamp, this.convertRate(metered.getOneMinuteRate()), MetricAttribute.M1_RATE, baseAttributes);
        Gauge fiveMinuteRate = this.makeGauge(ratesName, timestamp, this.convertRate(metered.getFiveMinuteRate()), MetricAttribute.M5_RATE, baseAttributes);
        Gauge fifteenMinuteRate = this.makeGauge(ratesName, timestamp, this.convertRate(metered.getFifteenMinuteRate()), MetricAttribute.M15_RATE, baseAttributes);
        return Stream.of(mean, oneMinuteRate, fiveMinuteRate, fifteenMinuteRate).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private double convertRate(double meanRate) {
        return (double)this.rateFactor * meanRate;
    }

    private Gauge makeGauge(String name, long timestamp, double count, MetricAttribute attribute, Supplier<Attributes> attributes) {
        if (!this.metricAttributePredicate.test(attribute)) {
            return null;
        }
        return new Gauge(name, count, timestamp, attributes.get().put("rate", attribute.getCode()));
    }
}

