/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.newrelic.transformer.interfaces;

import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.newrelic.transformer.interfaces.DropWizardComponentTransformer;
import com.codahale.metrics.newrelic.util.TimeTracker;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class SamplingTransformer
implements DropWizardComponentTransformer<Sampling> {
    private final TimeTracker timeTracker;
    private final double scaleFactor;

    public SamplingTransformer(TimeTracker timeTracker, double scaleFactor) {
        this.timeTracker = timeTracker;
        this.scaleFactor = scaleFactor;
    }

    @Override
    public Collection<Metric> transform(String name, Sampling sampling, Supplier<Attributes> baseAttributes) {
        Snapshot snapshot = sampling.getSnapshot();
        long now = this.timeTracker.getCurrentTime();
        long previousTime = this.timeTracker.getPreviousTime();
        Summary summary = new Summary(name, snapshot.size(), this.calculateSum(snapshot), this.scaleLongValue(snapshot.getMin()), this.scaleLongValue(snapshot.getMax()), previousTime, now, baseAttributes.get());
        Gauge median = new Gauge(name + ".percentiles", this.scaleDoubleValue(snapshot.getMedian()), now, this.buildAttributes(baseAttributes.get(), 0.5).put("commonName", "median"));
        Stream<Gauge> gauges = Stream.of(0.75, 0.95, 0.98, 0.99, 0.999).map(percentile -> new Gauge(name + ".percentiles", this.scaleDoubleValue(snapshot.getValue(percentile.doubleValue())), now, this.buildAttributes((Attributes)baseAttributes.get(), (Double)percentile)));
        return Stream.concat(Stream.of(median, summary), gauges).collect(Collectors.toSet());
    }

    private double scaleLongValue(long value) {
        return (double)value / this.scaleFactor;
    }

    private double scaleDoubleValue(double value) {
        return value / this.scaleFactor;
    }

    private Attributes buildAttributes(Attributes baseAttributes, Double percentile) {
        return baseAttributes.put("percentile", (Number)(percentile * 100.0));
    }

    private double calculateSum(Snapshot snapshot) {
        return LongStream.of(snapshot.getValues()).asDoubleStream().sum();
    }
}

