/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.util.DoubleFormat;
import java.util.Collections;
import java.util.function.Function;

public class HistogramGaugeCustomizer {
    public void registerHistogramGauges(Timer timer, MeterRegistry registry) {
        this.registerHistogramGauges((HistogramSupport)timer, percentile -> percentile.value(timer.baseTimeUnit()), registry);
    }

    public void registerHistogramGauges(DistributionSummary summary, MeterRegistry registry) {
        this.registerHistogramGauges((HistogramSupport)summary, ValueAtPercentile::value, registry);
    }

    private void registerHistogramGauges(HistogramSupport histogramSupport, Function<ValueAtPercentile, Double> toDouble, MeterRegistry registry) {
        Meter.Id id = histogramSupport.getId();
        HistogramGauges.register((HistogramSupport)histogramSupport, (MeterRegistry)registry, percentile -> id.getName() + ".percentiles", percentile -> Tags.concat((Iterable)id.getTagsAsIterable(), (String[])new String[]{"percentile", DoubleFormat.decimalOrNan((double)(percentile.percentile() * 100.0))}), toDouble, bucket -> id.getName() + ".histogram", bucket -> Collections.emptyList());
    }
}

