/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer;

import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import io.micrometer.core.ipc.http.HttpSender;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class MicrometerHttpPoster
implements HttpPoster {
    private final HttpSender sender;

    public MicrometerHttpPoster(HttpSender sender) {
        this.sender = sender;
    }

    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        try {
            HttpSender.Request.Builder request = this.sender.post(url.toString()).withContent(mediaType, body);
            headers.forEach((arg_0, arg_1) -> ((HttpSender.Request.Builder)request).withHeader(arg_0, arg_1));
            HttpSender.Response response = request.send();
            return this.convertResponse(response);
        }
        catch (Throwable th) {
            throw new IOException("Error posting metrics to New Relic", th);
        }
    }

    private HttpResponse convertResponse(HttpSender.Response response) {
        String body = response.body();
        int code = response.code();
        return new HttpResponse(body, code, "Response code: " + code, Collections.emptyMap());
    }
}

