/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.EventBatchSenderFactory;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.SpanBatchSenderFactory;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;

public class Java11HttpPoster
implements HttpPoster {
    private final HttpClient httpClient;

    public Java11HttpPoster(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Java11HttpPoster(Duration callTimeout) {
        this.httpClient = HttpClient.newBuilder().connectTimeout(callTimeout).build();
    }

    public Java11HttpPoster() {
        this(Duration.ofSeconds(2L));
    }

    @Override
    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(url.toURI()).POST(HttpRequest.BodyPublishers.ofByteArray(body));
            headers.forEach(builder::header);
            builder.header("Content-Type", mediaType);
            HttpRequest req = builder.build();
            java.net.http.HttpResponse<String> response = this.httpClient.send(req, HttpResponse.BodyHandlers.ofString(Charset.defaultCharset()));
            return Java11HttpPoster.toSdkResponse(response);
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static HttpResponse toSdkResponse(java.net.http.HttpResponse actual) {
        return new HttpResponse(actual.body().toString(), actual.statusCode(), "" + actual.statusCode(), actual.headers().map());
    }

    public static MetricBatchSenderFactory metricSenderFactory() {
        return MetricBatchSenderFactory.fromHttpImplementation(Java11HttpPoster::new);
    }

    public static SpanBatchSenderFactory spanSenderFactory() {
        return SpanBatchSenderFactory.fromHttpImplementation(Java11HttpPoster::new);
    }

    public static EventBatchSenderFactory eventSenderFactory() {
        return EventBatchSenderFactory.fromHttpImplementation(Java11HttpPoster::new);
    }
}

