/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitingScheduler {
    private static final Logger logger = LoggerFactory.getLogger(LimitingScheduler.class);
    private final ScheduledExecutorService executor;
    private final int max;
    private final Semaphore semaphore;

    public LimitingScheduler(ScheduledExecutorService executor, int max) {
        this.executor = executor;
        this.max = max;
        this.semaphore = new Semaphore(max);
    }

    public boolean schedule(int size, Runnable command) {
        return this.schedule(size, command, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean schedule(int size, Runnable command, long delay, TimeUnit unit) {
        if (!this.semaphore.tryAcquire(size)) {
            logger.warn("Refusing to schedule batch of size " + size + " (would put us over max size " + this.max + ", available = " + this.semaphore.availablePermits() + ")");
            logger.warn("DATA IS BEING LOST!");
            return false;
        }
        try {
            this.executor.schedule(() -> {
                try {
                    command.run();
                }
                finally {
                    this.semaphore.release(size);
                }
            }, delay, unit);
            return true;
        }
        catch (RejectedExecutionException e) {
            logger.warn("Data is being lost, job could not be scheduled", (Throwable)e);
            this.semaphore.release(size);
            return false;
        }
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public boolean awaitTermination(int shutdownSeconds, TimeUnit seconds) throws InterruptedException {
        return this.executor.awaitTermination(shutdownSeconds, seconds);
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }
}

