/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.NotificationHandler;
import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.TelemetryBatch;
import org.slf4j.Logger;

public class LoggingNotificationHandler
implements NotificationHandler {
    private final Logger logger;

    LoggingNotificationHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void noticeInfo(String message, Exception exception, TelemetryBatch<? extends Telemetry> batch) {
        this.logger.info(this.addBatchType(message, batch), (Throwable)exception);
    }

    @Override
    public void noticeError(String message, Throwable t, TelemetryBatch<? extends Telemetry> batch) {
        this.logger.error(this.addBatchType(message, batch), t);
    }

    private String addBatchType(String message, TelemetryBatch<? extends Telemetry> batch) {
        if (batch != null) {
            return String.format("[%s] - %s", batch.getClass().getSimpleName(), message);
        }
        return message;
    }
}

