/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class TelemetryBatch<T extends Telemetry> {
    private final UUID uuid = Utils.generateUUID();
    private Collection<T> telemetry;
    private Attributes commonAttributes;

    public TelemetryBatch(Collection<T> telemetry, Attributes commonAttributes) {
        this.telemetry = Utils.verifyNonNull(telemetry);
        this.commonAttributes = Utils.verifyNonNull(commonAttributes);
    }

    public List<TelemetryBatch<T>> split() {
        if (this.telemetry.isEmpty()) {
            return Collections.emptyList();
        }
        int totalSize = this.telemetry.size();
        int halfSize = totalSize / 2;
        return Arrays.asList(this.createSubBatch(this.telemetry.stream().limit(halfSize).collect(Collectors.toList())), this.createSubBatch(this.telemetry.stream().skip(halfSize).collect(Collectors.toList())));
    }

    public int size() {
        return this.telemetry.size();
    }

    public boolean hasCommonAttributes() {
        return !this.commonAttributes.isEmpty();
    }

    public boolean isEmpty() {
        return this.telemetry.isEmpty();
    }

    public abstract TelemetryBatch<T> createSubBatch(Collection<T> var1);

    public Collection<T> getTelemetry() {
        return this.telemetry;
    }

    public Attributes getCommonAttributes() {
        return this.commonAttributes;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryBatch that = (TelemetryBatch)o;
        if (this.getTelemetry() != null ? !this.getTelemetry().equals(that.getTelemetry()) : that.getTelemetry() != null) {
            return false;
        }
        return this.getCommonAttributes() != null ? this.getCommonAttributes().equals(that.getCommonAttributes()) : that.getCommonAttributes() == null;
    }

    public int hashCode() {
        int result = this.getTelemetry() != null ? this.getTelemetry().hashCode() : 0;
        result = 31 * result + (this.getCommonAttributes() != null ? this.getCommonAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TelemetryBatch{telemetry=" + String.valueOf(this.telemetry) + ", commonAttributes=" + String.valueOf(this.commonAttributes) + "}";
    }
}

