/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.http;

import java.util.List;
import java.util.Map;

public final class HttpResponse {
    private final String body;
    private final int code;
    private final String message;
    private final Map<String, List<String>> headers;

    public HttpResponse(String body, int code, String message, Map<String, List<String>> headers) {
        this.body = body;
        this.code = code;
        this.message = message;
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponse that = (HttpResponse)o;
        if (this.getCode() != that.getCode()) {
            return false;
        }
        if (this.getBody() != null ? !this.getBody().equals(that.getBody()) : that.getBody() != null) {
            return false;
        }
        if (this.getMessage() != null ? !this.getMessage().equals(that.getMessage()) : that.getMessage() != null) {
            return false;
        }
        return this.getHeaders() != null ? this.getHeaders().equals(that.getHeaders()) : that.getHeaders() == null;
    }

    public int hashCode() {
        int result = this.getBody() != null ? this.getBody().hashCode() : 0;
        result = 31 * result + this.getCode();
        result = 31 * result + (this.getMessage() != null ? this.getMessage().hashCode() : 0);
        result = 31 * result + (this.getHeaders() != null ? this.getHeaders().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpResponse{body='" + this.body + "', code=" + this.code + ", message='" + this.message + "', headers=" + String.valueOf(this.headers) + "}";
    }
}

