/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.json;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.stream.Collectors;

public class AttributesJson {
    public String toJson(Map<String, Object> attributes) {
        StringWriter out = new StringWriter();
        Map<String, Object> filteredAttributes = this.filterIllegalValues(attributes);
        if (filteredAttributes.isEmpty()) {
            return "{}";
        }
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)out);
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> attribute : filteredAttributes.entrySet()) {
                Object value = attribute.getValue();
                if (value instanceof Boolean) {
                    jsonWriter.name(attribute.getKey()).value(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Number) {
                    Number num = (Number)value;
                    jsonWriter.name(attribute.getKey()).value(num);
                    continue;
                }
                jsonWriter.name(attribute.getKey()).value(String.valueOf(value));
            }
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate attributes json");
        }
        return out.toString();
    }

    private Map<String, Object> filterIllegalValues(Map<String, Object> attributes) {
        return attributes.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> !(entry.getValue() instanceof Number) || Double.isFinite(((Number)entry.getValue()).doubleValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

