/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.json.MetricBatchJsonCommonBlockWriter;
import com.newrelic.telemetry.metrics.json.MetricBatchJsonTelemetryBlockWriter;
import com.newrelic.telemetry.metrics.json.MetricBatchMarshaller;
import com.newrelic.telemetry.metrics.json.MetricToJson;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBatchSender {
    private static final String METRICS_PATH = "/metric/v1";
    private static final String DEFAULT_URL = "https://metric-api.newrelic.com";
    private static final String EUROPEAN_URL = "https://metric-api.eu.newrelic.com";
    private static final Logger logger = LoggerFactory.getLogger(MetricBatchSender.class);
    private final MetricBatchMarshaller marshaller;
    private final BatchDataSender sender;

    MetricBatchSender(MetricBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    public Response sendBatch(MetricBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending of an empty metric batch.");
            return new Response(202, "Ignored", "Empty batch");
        }
        logger.debug("Sending a metric batch (number of metrics: {}) to the New Relic metric ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch);
    }

    public static MetricBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return MetricBatchSender.create(MetricBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static MetricBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        String userRegion = configuration.getRegion();
        String defaultUrl = "https://metric-api.newrelic.com/metric/v1";
        String endpointUrlToString = configuration.getEndpointUrl().toString();
        URL url = null;
        if (!endpointUrlToString.equals(defaultUrl)) {
            url = configuration.getEndpointUrl();
        } else {
            try {
                url = MetricBatchSender.returnEndpoint(userRegion);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        MetricBatchMarshaller marshaller = new MetricBatchMarshaller(new MetricBatchJsonCommonBlockWriter(new AttributesJson()), new MetricBatchJsonTelemetryBlockWriter(new MetricToJson()));
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent(), configuration.useLicenseKey());
        return new MetricBatchSender(marshaller, sender);
    }

    public static URL returnEndpoint(String userRegion) throws MalformedURLException {
        URL url = null;
        if (userRegion.equals("US")) {
            try {
                url = new URL("https://metric-api.newrelic.com/metric/v1");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (userRegion.equals("EU")) {
            try {
                url = new URL("https://metric-api.eu.newrelic.com/metric/v1");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        throw new MalformedURLException("A valid region (EU or US) needs to be added to generate the right endpoint");
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, METRICS_PATH);
    }
}

