/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.CommonAttributesBuilder;
import com.newrelic.telemetry.metrics.Count;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.util.IngestWarnings;
import com.newrelic.telemetry.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricBuffer {
    private static final Logger logger = LoggerFactory.getLogger(MetricBuffer.class);
    private final Queue<Metric> metrics = new ConcurrentLinkedQueue<Metric>();
    private final IngestWarnings ingestWarnings = new IngestWarnings();
    private final Attributes commonAttributes;

    public MetricBuffer(Attributes commonAttributes) {
        this.commonAttributes = Utils.verifyNonNull(commonAttributes);
    }

    public void addMetric(Metric metric) {
        this.raiseIngestWarnings(metric);
        this.metrics.add(metric);
    }

    private void raiseIngestWarnings(Metric metric) {
        if (metric instanceof Count) {
            this.ingestWarnings.raiseIngestWarnings(((Count)metric).getAttributes(), metric);
        } else if (metric instanceof Gauge) {
            this.ingestWarnings.raiseIngestWarnings(((Gauge)metric).getAttributes(), metric);
        } else if (metric instanceof Summary) {
            this.ingestWarnings.raiseIngestWarnings(((Summary)metric).getAttributes(), metric);
        }
    }

    public int size() {
        return this.metrics.size();
    }

    public MetricBatch createBatch() {
        Metric metric;
        logger.debug("Creating metric batch.");
        ArrayList<Metric> metrics = new ArrayList<Metric>(this.metrics.size());
        while ((metric = this.metrics.poll()) != null) {
            metrics.add(metric);
        }
        return new MetricBatch((Collection<Metric>)metrics, this.commonAttributes);
    }

    Queue<Metric> getMetrics() {
        return this.metrics;
    }

    Attributes getCommonAttributes() {
        return this.commonAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricBuffer that = (MetricBuffer)o;
        if (this.getMetrics() != null ? !this.getMetrics().equals(that.getMetrics()) : that.getMetrics() != null) {
            return false;
        }
        return this.getCommonAttributes() != null ? this.getCommonAttributes().equals(that.getCommonAttributes()) : that.getCommonAttributes() == null;
    }

    public int hashCode() {
        int result = this.getMetrics() != null ? this.getMetrics().hashCode() : 0;
        result = 31 * result + (this.getCommonAttributes() != null ? this.getCommonAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MetricBuffer{metrics=" + String.valueOf(this.metrics) + ", commonAttributes=" + String.valueOf(this.commonAttributes) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CommonAttributesBuilder commonAttributesBuilder = new CommonAttributesBuilder();

        public Builder attributes(Attributes attributes) {
            this.commonAttributesBuilder.attributes(attributes);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.commonAttributesBuilder.serviceName(serviceName);
            return this;
        }

        public Builder instrumentationProvider(String instrumentationProvider) {
            this.commonAttributesBuilder.instrumentationProvider(instrumentationProvider);
            return this;
        }

        public MetricBuffer build() {
            Attributes attributes = this.commonAttributesBuilder.build();
            return new MetricBuffer(attributes);
        }
    }
}

