/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.util.Utils;
import java.util.Map;

public final class Summary
implements Metric {
    private final String name;
    private final int count;
    private final double sum;
    private final double min;
    private final double max;
    private final long startTimeMs;
    private final long endTimeMs;
    private final Map<String, Object> attributes;

    public Summary(String name, int count, double sum, double min, double max, long startTimeMs, long endTimeMs, Attributes attributes) {
        this.name = Utils.verifyNonNull(name);
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.attributes = Utils.verifyNonNull(attributes).asMap();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public int getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Summary summary = (Summary)o;
        if (this.getCount() != summary.getCount()) {
            return false;
        }
        if (Double.compare(summary.getSum(), this.getSum()) != 0) {
            return false;
        }
        if (Double.compare(summary.getMin(), this.getMin()) != 0) {
            return false;
        }
        if (Double.compare(summary.getMax(), this.getMax()) != 0) {
            return false;
        }
        if (this.getStartTimeMs() != summary.getStartTimeMs()) {
            return false;
        }
        if (this.getEndTimeMs() != summary.getEndTimeMs()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(summary.getName()) : summary.getName() != null) {
            return false;
        }
        return this.getAttributes() != null ? this.getAttributes().equals(summary.getAttributes()) : summary.getAttributes() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.getCount();
        long temp = Double.doubleToLongBits(this.getSum());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getMin());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getMax());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.getStartTimeMs() ^ this.getStartTimeMs() >>> 32);
        result = 31 * result + (int)(this.getEndTimeMs() ^ this.getEndTimeMs() >>> 32);
        result = 31 * result + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Summary{name='" + this.name + "', count=" + this.count + ", sum=" + this.sum + ", min=" + this.min + ", max=" + this.max + ", startTimeMs=" + this.startTimeMs + ", endTimeMs=" + this.endTimeMs + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

