/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans.json;

import com.google.gson.stream.JsonWriter;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.json.SpanJsonCommonBlockWriter;
import com.newrelic.telemetry.spans.json.SpanJsonTelemetryBlockWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanBatchMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(SpanBatchMarshaller.class);
    private final SpanJsonCommonBlockWriter commonBlockWriter;
    private final SpanJsonTelemetryBlockWriter telemetryBlockWriter;

    public SpanBatchMarshaller(SpanJsonCommonBlockWriter commonBlockWriter, SpanJsonTelemetryBlockWriter telemetryBlockWriter) {
        this.commonBlockWriter = commonBlockWriter;
        this.telemetryBlockWriter = telemetryBlockWriter;
    }

    public String toJson(SpanBatch batch) {
        logger.debug("Generating json for span batch.");
        StringWriter out = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)out);
        try {
            jsonWriter.beginArray().beginObject();
            this.commonBlockWriter.appendCommonJson(batch, jsonWriter);
            this.telemetryBlockWriter.appendTelemetryJson(batch, jsonWriter);
            jsonWriter.endObject().endArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to marshall json for a span batch");
        }
        return out.toString();
    }
}

